import numpy as np
from pyppluss import segment_models as SSM
from numpy import ones_like as ol
import matplotlib.pyplot as plt

radius_planet = 0.1
radius_in = 0.15
radius_out = 0.2
y_planet = 0.0
x_planet = np.arange(-1.3,1.3,0.001)
ring_inclination = 80*np.pi/180
ring_rotation = 5*np.pi/180
opacity = 1.0
c1 = 0.0
c2 = 0.3
c3 = 0.2
c4 = 0.1

LC = SSM.LC_ringed(radius_planet*ol(x_planet), radius_in*ol(x_planet), radius_out*ol(x_planet), x_planet, y_planet*ol(x_planet), ring_inclination, ring_rotation, opacity, c1, c2, c3, c4)

plt.figure()
plt.plot(x_planet,LC)
plt.show()