;------------------------------------------------------------------------------;
pro VModelPlot
;------------------------------------------------------------------------------;
	common inputdata, mdirs, rlbs, bals, mags, dscs, keps
;------------------------------------------------------------------------------;
	common procdata, pmod, proj
;------------------------------------------------------------------------------;
	common workdata, vxy, vmax, dv
;------------------------------------------------------------------------------;
	common ovrdata, vcom, vl1, vl2, vbs, vbc, vms, vmsl, vmc, vdi, vdo, $
		vkt, vkc, nc, mcv
;------------------------------------------------------------------------------;
	; max no of colors of display
	mcol = !d.table_size - 1
;------------------------------------------------------------------------------;
	; small circle point symbol
	theta = 2 * !pi * findgen(49) / 48
	usersym, cos(theta), sin(theta), thick = 2;, /fill
;------------------------------------------------------------------------------;
	VModelRead
;------------------------------------------------------------------------------;
	; centres of mass and roche lobes
	if pmod eq 0 and rlbs eq 1 then begin
		; mark centre of mass with plus
		oplot, /polar, [vcom[0, 5 + proj]], [vcom[0, 3]], psym = 1, $
			symsize = 0.75
		; mark M1 with cross
		oplot, /polar, [vcom[1, 5 + proj]], [vcom[1, 3]], psym = 7, $
			symsize = 0.6, noclip = 1
		; mark M2 with cross
		oplot, /polar, [vcom[2, 5 + proj]], [vcom[2, 3]], psym = 7, $
			symsize = 0.6, noclip = 1
		; overlay lobe of M1
		ni = size(vl1, /n_elements) / 7
		oplot, /polar, vl1[0:ni-1, 5 + proj], vl1[0:ni-1, 3], line = 2
		; overlay lobe of M2
		ni = size(vl2, /n_elements) / 7
		oplot, /polar, vl2[0:ni-1, 5 + proj], vl2[0:ni-1, 3], line = 0
	endif
;------------------------------------------------------------------------------;
	; ballistic and magnetic streams, disc edges and keplerian trace
	if bals eq 1 then begin
		if pmod eq 0 then begin
			; overlay ballistic stream
			ni = size(vbs, /n_elements) / 7
			oplot, /polar, vbs[0:ni-1, 5 + proj], vbs[0:ni-1, 3], line = 0
			; overlay inner and outer disc edge, keplerian trace
			if mcv eq 0 then begin
				; inner edge
				ni = size(vdi, /n_elements) / 7
				oplot, /polar, vdi[0:ni-1, 5 + proj], vdi[0:ni-1, 3], line = 3
				; outer edge
				ni = size(vdo, /n_elements) / 7
				oplot, /polar, vdo[0:ni-1, 5 + proj], vdo[0:ni-1, 3], line = 0
				; keplerian trace
				if keps eq 1 then begin
					ni = size(vkt, /n_elements) / 7
					oplot, /polar, vkt[0:ni-1, 5 + proj], vkt[0:ni-1, 3], $
						line = 3
					; keplerian-ballistic connections
					ni = size(vkc, /n_elements) / 7
					oplot, /polar, vkc[0:ni-1, 5 + proj], vkc[0:ni-1, 3], $
						psym = 8, symsize = 0.75
				endif
			endif
		endif
		; overlay ballistic connections, magnetic stream
		if mcv ne 0 and mags ne 0 then begin
			if pmod eq 0 then begin
				; ballistic connections (red)
				ni = size(vbc, /n_elements) / 7
				oplot, /polar, vbc[0:ni-1, 5 + proj], vbc[0:ni-1, 3], $
					psym = 8, symsize = 0.65, color = 15
				vc = fltarr(2, 2)
				for i = 0, nc - 1, 2 do begin
					vc(0, 0) = vmc(i, 5 + proj)
					vc(0, 1) = vmc(i+1, 5 + proj)
					vc(1, 0) = vmc(i, 3)
					vc(1, 1) = vmc(i+1, 3)
					oplot, /polar, vc[0,0:1], vc[1,0:1], line = 1, color = 15
				endfor
			endif
			; magnetic stream - upper curtain (blue)
			ni = size(vms, /n_elements) / 7
			mi = where(vms[0:ni-1, 5 + proj] lt 1.1 * vmax, count)
			oplot, /polar, vms[mi, 5 + proj], vms[mi, 3], psym = 8, $
				symsize = 0.20, color = 75
			if mcv eq 2 then begin
				; magnetic stream - lower curtain (red)
				ni = size(vmsl, /n_elements) / 7
				mi = where(vms[0:ni-1, 5 + proj] lt 1.1 * vmax, count)
				oplot, /polar, vmsl[mi, 5 + proj], vmsl[mi, 3], $
					psym = 8, symsize = 0.20, color = 15
			endif
		endif
	endif
;------------------------------------------------------------------------------;
	if dscs ne 0 then begin
		phi = 2 * !pi * findgen(101) / 100.
		oplot, dscs * cos(phi), dscs * sin(phi) - vcom(0, 1), line = 0
	endif
;------------------------------------------------------------------------------;
	return
end
;------------------------------------------------------------------------------;
