! Code Aspects, version 2.0.1.
! Michel Fioc, 2014-4-29. 

module mod_output_prob

  use mod_files, only: new_unit
  use mod_types, only : real_type, prob_struct

  implicit none

  private
  public :: write_prob, output_sto_prob, output_ots_prob, output_oto_prob

contains

!======================================================================

  subroutine write_prob(unit, src, prob)

! Write in a file the probabilities of association to a given source
! of its counterparts.
    implicit none
    integer, intent(in) :: unit, src
    type(prob_struct), intent(in) :: prob
!......................................................................
    character(len=72) :: fmt, fmt_obj, fmt_n_ctp
    integer :: k, n_ctp
!______________________________________________________________________

    n_ctp = prob%n_ctp

    write(fmt_obj,*) src
    write(fmt_obj,*) max(len_trim(adjustl(fmt_obj)), 6)
    write(fmt_n_ctp,*) n_ctp
    write(fmt_n_ctp,*) max(len_trim(adjustl(fmt_n_ctp)), 2)
    fmt = "(i"//trim(adjustl(fmt_obj))//",tr2,i"//trim(adjustl(fmt_n_ctp))// &
         ",tr2,es10.4)"
    write(unit,fmt,advance="no") src, & ! Index of the source in the first 
!& catalog.
         n_ctp, & ! Number of possible real (excluding 0) counterparts 
!& in the second catalog.
         prob%prob(0) ! Probability that there is no counterpart.

! On the same line.
    if (n_ctp > 0) then
       write(fmt_n_ctp,*) n_ctp
       write(fmt_obj,*) maxval(prob%ctp(1:n_ctp))
       write(fmt_obj,*) max(len_trim(adjustl(fmt_obj)), 6)
       fmt = "("//trim(adjustl(fmt_n_ctp))//"(tr1,i"// &
            trim(adjustl(fmt_obj))//",tr1,es10.4))"
       write(unit,fmt) (prob%ctp(k), prob%prob(k), k = 1, n_ctp) ! List of
!&        possible counterparts (excluding 0): for each, index of the
!&        counterpart and corresponding probability of association.
    else
       write(unit,*) ! To cancel the ''advance="no"''.
    endif

  end subroutine write_prob

!======================================================================

  subroutine output_sto_prob(K_u_file, K_p_file, f_u, sto_prob_u_file, &
       sto_prob_p_file, sto_prob_u, sto_prob_p)

! Write several-to-one probabilities.
    implicit none
    character(len=*), intent(in) :: K_u_file, K_p_file, sto_prob_u_file, &
         sto_prob_p_file
    real(kind=real_type), intent(in) :: f_u
    type(prob_struct), dimension(:), intent(in) :: sto_prob_u, sto_prob_p
!......................................................................
    integer :: unit, n_u, n_p, i, j
!______________________________________________________________________

    n_u = size(sto_prob_u)
    n_p = size(sto_prob_p)
    unit = new_unit()
    open(unit=unit, file=sto_prob_u_file)
    write(unit,"(a)") "! Code Aspects, version 2.0."
    write(unit,"(a/)") "! Michel Fioc, 2014-4-15."
    write(unit,"(3a)") "! Catalog $K$: """, trim(K_u_file), """."
    write(unit,"(3a/)") "! Catalog $K'$: """, trim(K_p_file), """."
    write(unit,"(a)") "! Several-to-one $K$-$K'$ probabilities of associations"
    write(unit,"(a)") "! (i.e., a $K$-source has at most one counterpart in &
         &$K'$, but a $K'$-source may have several counterparts in $K$)."
    write(unit,"(a,f8.5,a/)") "Computed with $f$ = ", f_u, "."
    write(unit,"(a)") "! Each $K$-source corresponds to one line. On each line:"
    write(unit,"(a)") "! * index $i$ of the $K$-source $M_i$;"
    write(unit,"(a)") "! * number of possible real counterparts in $K'$ to &
         &$M_i$;"
    write(unit,"(a)") "! * probability that $M_i$ has no counterpart &
         &(corresponds to $j$ = 0); "
    write(unit,"(a)") "! * for each possible real counterpart $M'_j$ ($j$ > 0):"
    write(unit,"(a)") "!   -- index $j$ of the counterpart;"
    write(unit,"(a/)") "!   -- probability of association of $M_i$ with $M'_j$."
    do i = 1, n_u
       call write_prob(unit, i, sto_prob_u(i))
    enddo
    close(unit)

    unit = new_unit()
    open(unit=unit, file= sto_prob_p_file)
    write(unit,"(a)") "! Code Aspects, version 2.0."
    write(unit,"(a/)") "! Michel Fioc, 2014-4-15."
    write(unit,"(3a)") "! Catalog $K$: """, trim(K_u_file), """."
    write(unit,"(3a/)") "! Catalog $K'$: """, trim(K_p_file), """."
    write(unit,"(a)") "! Several-to-one $K$-$K'$ probabilities of associations"
    write(unit,"(a)") "! (i.e., a $K$-source has at most one counterpart in &
         &$K'$, but a $K'$-source may have several counterparts in $K$)."
    write(unit,"(a,f8.5,a/)") "Computed with $f$ = ", f_u, "."
    write(unit,"(a)") "! Each $K'$-source corresponds to one line. &
         &On each line:"
    write(unit,"(a)") "! * index $j$ of the $K'$-source $M'_j$;"
    write(unit,"(a)") "! * number of possible counterparts in $K$ to $M'_j$;"
    write(unit,"(a)") "! * probability that $M'_j$ has no counterpart &
         &(corresponds to $i$ = 0); "
    write(unit,"(a)") "! * for each possible real counterpart $M_i$ ($i$ > 0):"
    write(unit,"(a)") "!   -- index $i$ of the counterpart;"
    write(unit,"(a)") "!   -- probability of association of $M_i$ with $M'_j$."
    write(unit,"(a/)") "! (The sum of the probabilities may be different &
         &from 1.)"
    do j = 1, n_p
       call write_prob(unit, j, sto_prob_p(j))
    enddo
    close(unit)

  end subroutine output_sto_prob

!======================================================================

  subroutine output_ots_prob(K_u_file, K_p_file, f_p, ots_prob_u_file, &
       ots_prob_p_file, ots_prob_u, ots_prob_p)

! Write one-to-several probabilities.
    implicit none
    character(len=*), intent(in) :: K_u_file, K_p_file, ots_prob_u_file, &
         ots_prob_p_file
    real(kind=real_type), intent(in) :: f_p
    type(prob_struct), dimension(:), intent(in) :: ots_prob_u, ots_prob_p
!......................................................................
    integer :: unit, n_u, n_p, i, j
!______________________________________________________________________

    n_u = size(ots_prob_u)
    n_p = size(ots_prob_p)
    unit = new_unit()
    open(unit=unit, file=ots_prob_u_file)
    write(unit,"(a)") "! Code Aspects, version 2.0."
    write(unit,"(a/)") "! Michel Fioc, 2014-4-15."
    write(unit,"(3a)") "! Catalog $K$: """, trim(K_u_file), """."
    write(unit,"(3a/)") "! Catalog $K'$: """, trim(K_p_file), """."
    write(unit,"(a)") "! One-to-several $K$-$K'$ probabilities of associations"
    write(unit,"(a)") "! (i.e., a $K$-source may have several counterparts &
         &in $K'$, but a $K'$-source has at most one counterpart in $K$)."
    write(unit,"(a,f8.5,a/)") "Computed with $f'$ = ", f_p, "."
    write(unit,"(a)") "! Each $K$-source corresponds to one line. On each line:"
    write(unit,"(a)") "! * index $i$ of the $K$-source $M_i$;"
    write(unit,"(a)") "! * number of possible counterparts in $K'$ to $M_i$;"
    write(unit,"(a)") "! * probability that $M_i$ has no counterpart &
         &(corresponds to $j$ = 0); "
    write(unit,"(a)") "! * for each possible counterpart $M'_j$ ($j$ > 0):"
    write(unit,"(a)") "!   -- index $j$ of the counterpart;"
    write(unit,"(a)") "!   -- probability of association of $M_i$ with $M'_j$."
    write(unit,"(a/)") "! (The sum of the probabilities may be different &
         &from 1.)"
    do i = 1, n_u
       call write_prob(unit, i, ots_prob_u(i))
    enddo
    close(unit)

    unit = new_unit()
    open(unit=unit, file= ots_prob_p_file)
    write(unit,"(a)") "! Code Aspects, version 2.0."
    write(unit,"(a/)") "! Michel Fioc, 2014-4-15."
    write(unit,"(3a)") "! Catalog $K$: """, trim(K_u_file), """."
    write(unit,"(3a/)") "! Catalog $K'$: """, trim(K_p_file), """."
    write(unit,"(a)") "! One-to-several $K$-$K'$ probabilities of associations"
    write(unit,"(a)") "! (i.e., a $K$-source may have several counterparts &
         &in $K'$, &
         &but a $K'$-source has at most one counterpart in $K$)."
    write(unit,"(a,f8.5,a/)") "Computed with $f'$ = ", f_p, "."
    write(unit,"(a)") "! Each $K'$-source corresponds to one line. &
         &On each line:"
    write(unit,"(a)") "! * index $j$ of the $K'$-source $M'_j$;"
    write(unit,"(a)") "! * number of possible counterparts in $K$ to $M'_j$;"
    write(unit,"(a)") "! * probability that $M'_j$ has no counterpart &
         &(corresponds to $i$ = 0); "
    write(unit,"(a)") "! * for each possible real counterpart $M_i$ ($i$ > 0):"
    write(unit,"(a)") "!   -- index $i$ of the counterpart;"
    write(unit,"(a/)") "!   -- probability of association of $M_i$ with $M'_j$."
    do j = 1, n_p
       call write_prob(unit, j, ots_prob_p(j))
    enddo
    close(unit)

  end subroutine output_ots_prob

!======================================================================

  subroutine output_oto_prob(K_u_file, K_p_file, f, oto_prob_u_file, &
       oto_prob_p_file, oto_prob_u, oto_prob_p, swapped)

! Write one-to-one probabilities.
! `swapped` is optional and false by default. Use `swapped = .true.` if the 
! probabilities of association were computed from `assoc_data_p` and `f_p` 
! instead of `assoc_data_u` and `n_u`.
    implicit none
    character(len=*), intent(in) :: K_u_file, K_p_file, oto_prob_u_file, &
         oto_prob_p_file
    real(kind=real_type), intent(in) :: f
    type(prob_struct), dimension(:), intent(in) :: oto_prob_u, oto_prob_p
    logical, intent(in), optional :: swapped
!......................................................................
    integer :: unit, n_u, n_p, i, j
    logical :: swapped_tmp
!______________________________________________________________________

    swapped_tmp = .false.
    if (present(swapped)) then
       if (swapped) swapped_tmp = .true.
    endif

    n_u = size(oto_prob_u)
    n_p = size(oto_prob_p)
    unit = new_unit()
    open(unit=unit, file=oto_prob_u_file)
    write(unit,"(a)") "! Code Aspects, version 2.0."
    write(unit,"(a/)") "! Michel Fioc, 2014-4-15."
    write(unit,"(3a)") "! Catalog $K$: """, trim(K_u_file), """."
    write(unit,"(3a/)") "! Catalog $K'$: """, trim(K_p_file), """."
    if (swapped_tmp) then
       write(unit,"(a)") "! One-to-one $K'$-$K$ probabilities of associations"
    else
       write(unit,"(a)") "! One-to-one $K$-$K'$ probabilities of associations"
    endif
    write(unit,"(a)") "! (a $K$-source has at most one counterpart in $K'$, &
         &and a $K'$-source has at most one counterpart in $K$)."
    if (swapped_tmp) then
       write(unit,"(a,f8.5,a/)") "Computed with $f'$ = ", f, "."
    else
       write(unit,"(a,f8.5,a/)") "Computed with $f$ = ", f, "."
    endif
    write(unit,"(a)") "! Each $K$-source corresponds to one line. On each line:"
    write(unit,"(a)") "! * index $i$ of the $K$-source $M_i$;"
    write(unit,"(a)") "! * number of possible counterparts in $K'$ to $M_i$;"
    write(unit,"(a)") "! * probability that $M_i$ has no counterpart &
         &(corresponds to $j$ = 0); "
    write(unit,"(a)") "! * for each possible real counterpart $M'_j$ ($j$ > 0):"
    write(unit,"(a)") "!   -- index $j$ of the counterpart;"
    write(unit,"(a/)") "!   -- probability of association of $M_i$ with $M'_j$."
    do i = 1, n_u
       call write_prob(unit, i, oto_prob_u(i))
    enddo
    close(unit)

    unit = new_unit()
    open(unit=unit, file=oto_prob_p_file)
    write(unit,"(a)") "! Code Aspects, version 2.0."
    write(unit,"(a/)") "! Michel Fioc, 2014-4-15."
    write(unit,"(3a)") "! Catalog $K$: """, trim(K_u_file), """."
    write(unit,"(3a/)") "! Catalog $K'$: """, trim(K_p_file), """."
    if (swapped_tmp) then
       write(unit,"(a)") "! One-to-one $K'$-$K$ probabilities of associations"
    else
       write(unit,"(a)") "! One-to-one $K$-$K'$ probabilities of associations"
    endif
    write(unit,"(a)") "! (a $K$-source has at most one counterpart in $K'$, &
         &and a $K'$-source has at most one counterpart in $K$)."
    if (swapped_tmp) then
       write(unit,"(a,f8.5,a/)") "Computed with $f'$ = ", f, "."
    else
       write(unit,"(a,f8.5,a/)") "Computed with $f$ = ", f, "."
    endif
    write(unit,"(a)") "! Each $K'$-source corresponds to one line. &
         &On each line:"
    write(unit,"(a)") "! * index $j$ of the $K'$-source $M'_j$;"
    write(unit,"(a)") "! * number of possible counterparts in $K$ to $M'_j$;"
    write(unit,"(a)") "! * probability that $M'_j$ has no counterpart &
         &(corresponds to $i$ = 0); "
    write(unit,"(a)") "! * for each possible real counterpart $M_i$ ($i$ > 0):"
    write(unit,"(a)") "!   -- index $i$ of the counterpart;"
    write(unit,"(a/)") "!   -- probability of association of $M_i$ with $M'_j$."
    do j = 1, n_p
       call write_prob(unit, j, oto_prob_p(j))
    enddo
    close(unit)

  end subroutine output_oto_prob

end module mod_output_prob
