#!/bin/bash
################################################################################
# remember: chmod 755 4-idl.doptomog.pre.sh
################################################################################
# set parent directory
prtdir=$(pwd)
# set code directory
cdedir=$prtdir/code
# set script directory
scpdir=$prtdir/scripts
# set sources directory
srcdir=$prtdir/sources
################################################################################
# get source folder name
result=1
while [ $result -eq 1 ]; do
	read -p "Source folder name (e.g., mcv, etc.)? "
	if [ ! -z "$REPLY" ]; then
		# call validatedir.sh to check if source folder exists
		source $scpdir/shell/validatedir.sh $srcdir $REPLY 1
		result=$?
	fi
done
# set source
src=$REPLY
# set source folder path
srcfldr=$srcdir/$src
################################################################################
# call validatedir.sh to check if doptomog output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out doptomog 1
if [ "$?" -eq 1 ]; then exit; fi
################################################################################
# go to idl script folder...
cd $scpdir/idl
# process tomogram files
# set doptomog source path
sdir=$srcfldr/out/doptomog/
# loop for standard and inside-out projections
for ((i=0; i<=1; i++))
do
	if [ $i -eq 0 ]; then mth="standard"; fi
	if [ $i -eq 1 ]; then mth="inside-out"; fi
	read -p "Execute 'doptomog' pre IDL script for $src $mth projection (y/n)? "
	if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
		# set doptomog source file
		inf="doptomog.$i.out"
		# execute idl script
		echo "executing 'doptomogplotpre.pro' in IDL for $src $mth projection..."
		cmd="sdir='$sdir', inf='$inf', suf='.$i'"
		idl -e "DopTomogPlotPre, $cmd"
		# display output
		read -p "Display output (y/n)? "
		if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
			gnome-open $srcfldr/out/doptomog/doptomog.$i.ps &
		fi
	fi
done
################################################################################
# process flux modulation mapping files
# call validatedir.sh to check if fluxmodmap doptomog output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out/doptomog fluxmodmap 0
if [ "$?" -eq 0 ]; then
	# set fluxmodmap doptomog source path
	sdir=$srcfldr/out/doptomog/fluxmodmap/
	# loop for standard and inside-out projections
	for ((i=0; i<=1; i++))
	do
		if [ $i -eq 0 ]; then mth="standard"; fi
		if [ $i -eq 1 ]; then mth="inside-out"; fi
		read -p "Execute 'doptomog' pre IDL script for $src $mth projection for flux modulation mapping (y/n)? "
		if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
			# set doptomog source file
			inf="fluxmodmap.$i.out"
			# execute idl script
			echo "executing 'doptomogplotpre.pro' in IDL for $src $mth projection..."
			cmd="sdir='$sdir', inf='$inf', suf='.$i'"
			idl -e "DopTomogPlotPre, $cmd"
			# display output
			read -p "Display output (y/n)? "
			if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
				gnome-open $sdir/doptomog.$i.ps &
			fi
		fi
	done
fi
################################################################################
# process half-phase tomogram files
# call validatedir.sh to check if halfphases doptomog output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out/doptomog halfphases 0
if [ "$?" -eq 0 ]; then
	# set halfphases doptomog source path
	sdir=$srcfldr/out/doptomog/halfphases/
	# loop for standard and inside-out projections
	for ((i=0; i<=1; i++))
	do
		if [ $i -eq 0 ]; then mth="standard"; fi
		if [ $i -eq 1 ]; then mth="inside-out"; fi
		# get nr of halfphases files
		nr=$(head -n 1 $srcfldr/out/doptomog/halfphases/halfphases.$i.out)
		n="$[$nr]"
		read -p "Execute 'doptomog' pre IDL script for $src $mth projection for $n half-phases (y/n)? "
		if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
			n="$[$n-1]"
			for ((k=0; k<=$n; k++))
			do
				# set doptomog source file
				inf="doptomog.$i.$k.out"
				# execute idl script
				echo "$k : executing 'doptomogplotpre.pro' in IDL for $src $mth projection..."
				cmd="sdir='$sdir', inf='$inf', suf='.$i.$k'"
				idl -e "DopTomogPlotPre, $cmd"
				# display output
				read -p "Display output (y/n)? "
				if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
					gnome-open $sdir/doptomog.$i.$k.ps &
				fi
			done
		fi
	done
fi
################################################################################
# back to parent directory
cd $prtdir
################################################################################
# continue (exit)
source $scpdir/shell/continue.sh 1
################################################################################
