#!/usr/bin/perl
#print "Change DIR in driver.pl, put MOOG in silent mood (change moog.f), change Infile.f to read directly something2.par\n";
$obsfile=$ARGV[0];
$parfile=$ARGV[1];
$p=$ARGV[2];

print "P parameter: $p\n";
$obsfilenew="obs_sigma.dat";


if (! $obsfile ) {
   print "Usage: driver.pl EWs_file Par_file\n";
   exit;
}
$automoogpar="automoog.par";

open( INPAR,    $automoogpar)      || die;
while (<INPAR>) {
(@aryin ) = split;
#push @dir, $aryin[0];
}
close (INPAR);



$DIR=$aryin[0];
$DIR1=$aryin[1];
$DIRATMO=$aryin[2];

#dir with atmospheric models
#$DIRATMO = "${DIR}MARCS_MODELS/";
#prepare the dirs for INPUT and OUTPUT files
system "mkdir ${DIR1}/INPUT\n";
system "mkdir ${DIR1}/OUTPUT\n";

$res      = "${DIR1}/RESULTS";


#preparation of the file in the correct form for moog
$filetemp="${DIR1}/myfile2";
$filetemp1="${DIR1}/myfile3";
$filetemp2="${DIR1}/myfile4";
#files with the number of FeII lines
$filefeii="${DIR1}/file_line_feii";


#remove the first and last line from EW file

system "rm myfile*\n";

#run the first model of stellar atmosphere
system "$DIRATMO/makekurucz64.e < $parfile\n";
#system "${DIRATMO}/marcs_auto_sp.pl ${DIR1}/$parfile\n";
#system "${DIRATMO}/interpol_perl.com\n";
#now the file is ready for moog

#with FeI and FeII separately to do a separate sclipping
 
@i = ('26.0','26.1');
#@i = ('26.0');
foreach $item (@i)
{
system "grep '$item ' $obsfile > obsfile$item\n";
#add  new line at the end
system "echo ' ' >> obsfile$item\n";
#sort to put the new line at the beginning
system "sort -k 2  obsfile$item -o obsfile$item\n";

#preparing the input file for MOOG
system "rm ./something2.par";
$out1="./something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       'obsfile$item'
atmosphere      0
molecules       1
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI
#running MOOG
system "./MOOG\n";
print "Running MOOG\n";



# read  out2 and gives  slopes of  correlations, average Fe and FeII abundances, and sigmas   
system "${DIR1}/read_final.pl out2";
#sigmaclipping
print "Now processing element with atommic number $item\n";
system "./sclipping_$item.pl obsfile$item obsfilenew$item\n";


}

#this files contains the EWs of all elements after a 2sclipping

system "cat obsfilenew??.? > obsfilenew.dat";

#add  new line at the beginning
system "sort -r -k 2 obsfilenew.dat -o obsfilenew.dat\n";
system " echo  ' ' > p\n";
system "cat p obsfilenew.dat  >> $filetemp2\n";
system "mv $filetemp2 obs_sigma.dat\n";




#loop
$iteration="01";
$it=1;
$continue=1;
$out0="${DIR1}/something2.par";
open (OUT0, ">$out0");
print OUT0 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       '$obsfilenew'
atmosphere      1
molecules       2
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI


#running MOOG
system "${DIR1}/MOOG\n";
print "Running MOOG\n";


# read  out2 and gives  slopes of  correlations, average Fe and FeII abundances, and sigmas   
system "${DIR1}/read_out2.pl";
print "Writing the slope of FeI, average FeI e FeII in slope_out2\n";

#after the first MOOG run we do a 2-sigma clipping for FeI and FeII separately

print "Next step: first iteration with MOOG\n";
#copy the starting input file in  the INPUT dir 
system "cp $parfile ${DIR1}/INPUT/input_file_01";

while ($continue) {
  $iteration=sprintf "%02d", $it;
  $itplusone=$it+1;
  $itminusone=$it-1;
  $iterationplusone=sprintf "%02d", $itplusone;
  $iterationminusone=sprintf "%02d", $itminusone;
  print "iteration: $iteration\n";
  $input="${DIR1}/INPUT/input_file_${iteration}";


#here the par file for MOOG, it changes with MOOG versions
 
system "rm ${DIR1}/something2.par";
$out1="${DIR1}/something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       '$obsfilenew'
atmosphere      1
molecules       2
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI

#run the  models of stellar atmosphere
print "input: $input\n";
#marcs models
#system "rm $res\n";
#system "rm ${DIRATMO}interpol_perl.com\n";
system "$DIRATMO/makekurucz64.e < $input\n";
#system "$DIRATMO/marcs_auto_sp.pl $input\n";
#system "chmod 777 ${DIRATMO}interpol_perl.com\n";
#system "$DIRATMO/interpol_perl.com\n";

#check on model atmo
$res      = "RESULTS";
open( RES,    $res )      || die;
#system "rm $res\n";
#running MOOG
system "${DIR1}/MOOG\n";
print "Running MOOG\n";

# read  out2 and gives  slopes of  correlations, average Fe and FeII abundances, and sigmas   
system "${DIR1}/read_out2.pl";
print "Writing the slope of FeI, average FeI e FeII in slope_out2\n";


# start the loop driven by confronta.pl
  print "iteration: $iteration - iterationplusone: $iterationplusone - - slope_out2: $slope_out2 P parameter: $p\n";
print "Input EW file: $obsfilenew\n"; 
  $continue=(system "${DIR1}/confronta.pl $iteration $iterationplusone  $slope_out2 $p "); 
  $it++; 
#maximum number of iteration =1000 (it can be changed)
  if ($it > 500) {exit}
#before exiting, the final out2 and out1 are written in OUTPUT dir, and also the last input file
  if ($continue==0) {
#final files in the OUTPUT dir
system "cp  ${DIR1}/out2 ${DIR1}/OUTPUT/${obsfile}.out2\n";
system "cp  ${DIR1}/out1 ${DIR1}/OUTPUT/${obsfile}.out1\n";
system "cp  ${DIR1}/INPUT/input_file_${iteration} ${DIR1}/OUTPUT/${obsfile}.input\n";
system "cp  ${DIR1}/$obsfilenew  ${DIR1}/OUTPUT/${obsfile}.sigma\n";

#store everything in a log file
system "echo $obsfile $it M --------- >> temp0.log\n";
system "paste $parfile temp0.log > temp.log\n";
system "paste temp.log ${DIR1}/OUTPUT/${obsfile}.input >> log.log\n";
system "rm temp0.log\n";
system "rm temp.log\n";
system "date >> log.time\n"

}

}
