#!/usr/bin/perl   
use strict;  




#arguments given by  driver.pl
my $iteration        = $ARGV[0];
my $iterationplusone = $ARGV[1];
my $slope_out2       = $ARGV[3];
my $p                = $ARGV[2];

my $automoogpar="automoog.par";



open( INPAR,    $automoogpar)      || die;
$_ = <INPAR>;
my( @aryin ) = split;
my $DIR    = $aryin[1];
close (INPAR);




print "P parameter: $p\n";
print "iteration: $iteration\n";
print "iteration+1: $iterationplusone\n";


my $input      = "${DIR}/INPUT/input_file_${iteration}";
print "qui: $input\n";
my $slope_out2 = "${DIR}/slope_out2";
print "slope: $slope_out2\n";
my $out = "${DIR}/INPUT/input_file_${iterationplusone}";

open( IN,    $input )      || die;
open( SLOPE, $slope_out2 ) || die;
open( OUT,  ">$out" )     || die;

#read the slopes in out2  of  MOOG:

$_ = <SLOPE>;
my( @ary ) = split;
my $av_abu_fei    = $ary[0];
my $s_abu_fei     = $ary[1];
my $slope_ep  = $ary[2];
my $slope_rw  = $ary[3];
my $slope_waw = $ary[4];
my $av_abu_feii    = $ary[5];
my $s_abu_feii     = $ary[6];    
close (SLOPE);



#open the files with number of iron lines
open (LINES, "linesfei.dat") || die;

$_ = <LINES>;
my( @aryl ) = split;
my $lines    = $aryl[0];
close (LINES);

print "number of FeI lines: $lines\n";

#open the files with number of iron lines
open (LINES2, "linesfeii.dat") || die;

$_ = <LINES2>;
my( @aryl2 ) = split;
my $lines2    = $aryl2[0];
close (LINES2);


# minimum slopes and ironI-ironII differences
my $ep_final=$s_abu_fei/5;
my $rw_final=$s_abu_fei/1.5;
my $grav_final=sqrt($s_abu_fei**2+$s_abu_feii**2);


print "Minimizing slopes (last step /2):  $ep_final $rw_final\n";  
print "Minimizing gravity (last step /2): $grav_final\n";
#difference between FeI and FeII
my $diff_iron=$av_abu_feii-$av_abu_fei;

print "number of FeII lines: $lines2\n";
print "if number of FeII lines < 4 gravity is the input one\n";

if ($lines2<4){
    $diff_iron = 0}else{$diff_iron=$av_abu_feii-$av_abu_fei}


print "number of FeI lines: $lines\n";
print "if number of FeI lines < 8 fixing Teff to photometric value\n";
print "if number of FeI lines < 20 the p parameter is 1\n";

if ($lines<8){
   $ep_final = 100 && $rw_final=100
}elsif($lines<20){$p=5}

print "FeII $av_abu_feii\n";  
print "FeII-FeI $diff_iron\n";
#solar [Fe/H]
my $feh_sun=$av_abu_fei-7.45;
# read previous input for atmospheric models
$_ = <IN>;
my (@ary1 ) = split;
my $teff  = $ary1[0];
my $logg  = $ary1[1];
my $feh   = $ary1[2];
my $micro = $ary1[3]; 
close(IN);

#check the metallicity ond change from [Fe/H]=0 to the value measured by MOOG
$feh=$feh_sun;

#computing microturbolence
my $t0 = 5500;
my $g0 = 4.0;
if (abs($slope_rw) > 1.50) {print "Microturbolence cannot be fixed, setting to logg-teff relation value\n";
if ($teff >= 5250 && $logg >= 3.5){
$micro = 1.15 + 2*10**(-4)*($teff-$t0) + 3.95*10**(-7)*($teff-$t0)**2 - 0.13*($logg-$g0) + 0.13*($logg-$g0)**2}
elsif ($teff < 5250 && $logg >= 3.5){
$micro = 1.15 + 2*10**(-4)*(5250-$t0) + 3.95*10**(-7)*(5250-$t0)**2 - 0.13*($logg-$g0) + 0.13*($logg-$g0)**2}
elsif ( $logg < 3.5){
    $micro = 0.94 + 2.2*10**(-5)*($teff-$t0) - 0.5*10**(-7)*($teff-$t0)**2 - 0.1*($logg-$g0) + 0.04*($logg-$g0)**2}
print "Microturbolence from Teff-logg relation: $micro\n";
		    $slope_rw=0;
}
else{print "RW correlation $slope_rw\n"}



#first cycle on Teff
if ( $slope_ep > 3*$ep_final  ) {
    $teff += 300.0;
    printnewvalues();
    print "Correcting Teff (first cycle): $teff\n";
    exit(1);
}
elsif ( $slope_ep < -3*$ep_final ) {
    $teff -= 300;
    printnewvalues();
    print "Correcting Teff (first cycle): $teff\n";
    exit(1);
}
elsif ( $slope_ep >= -3*$ep_final &&  $slope_ep <= 3*$ep_final ) {
     print "Teff for the first cycle is OK: $teff\n";
}

if ( $diff_iron < -6) {
print "Missing EP slopes, Teff cannot be contrained, exit\n";
exit;
}


#first cycle on gravity


if ( $diff_iron > 3*$grav_final && $logg <=4.9 && $logg >=0.21) {
    $logg -= 0.8;
    printnewvalues();
    print "Correcting Log(g) (first cycle): $logg\n";
    exit(1);
}
elsif ( $diff_iron < -3*$grav_final && $diff_iron>-2 && $logg <=4.9 && $logg >=0.21) {
    $logg += 0.8;
    printnewvalues();
    print "Correcting Log(g) (first cycle): $logg\n";
    exit(1);
}
elsif ($logg >5.) { 
    $logg -= 0.01;
    printnewvalues();
    print "Maximun value allowed for gravity: $logg\n";
    exit(1);
}elsif ($logg <0.21) { 
    $logg += 0.01;
    printnewvalues();
    print "Miminum value allowed for gravity: $logg\n";
    exit(1);
}elsif ( $diff_iron >= -3*$grav_final &&  $diff_iron <= 3*$grav_final && $logg <=4.9 && $logg >=0.21) {
     print "Log(g) for the first cycle is OK: $logg\n";
}

#first cycle on microturbolence 
if ( $slope_rw > 3*$rw_final && $micro < 5.0 && $micro > 0.1 ) {
    $micro += 0.25;
    printnewvalues();
    print "Correcting Microturbolence (first cycle): $micro\n";
    exit(1);
}
elsif ( $slope_rw < -3*$rw_final  && $micro < 5.0 && $micro > 0.1 ) {
    $micro -= 0.25;
    printnewvalues();
    print "Correcting Microturbolence (first cycle): $micro\n";
    exit(1);
}
elsif ( $slope_rw >= -3*$rw_final &&  $slope_rw <= 3*$rw_final  && $micro <= 5.0 && $micro >= 0.1) {
     print "Microturbolence for the first cycle is OK: $micro\n";
}
#check the metallicity ond change from [Fe/H]=0 to the value measured by MOOG
$feh=$feh_sun;

#second cycle on Teff 
if ( $slope_ep > 2*$ep_final  ) {
    $teff += 100.0;
    printnewvalues();
    print "Correcting Teff (second cycle): $teff\n";
    exit(1);
}
elsif ( $slope_ep < -2*$ep_final ) {
    $teff -= 100;
    printnewvalues();
    print "Correcting Teff (second cycle): $teff\n";
    exit(1);
}
elsif ( $slope_ep > 1.5*$ep_final   ) {
    $teff += 50.0;
    printnewvalues();
    print "Correcting Teff (second cycle): $teff\n";
    exit(1);
}
elsif ( $slope_ep < -1.5*$ep_final  ) {
    $teff -= 50;
    printnewvalues();
    print "Correcting Teff (second cycle): $teff\n";
    exit(1);
}
elsif ( $slope_ep >= -1.5*$ep_final &&  $slope_ep <= 1.5*$ep_final ) {
     print "Teff for the second cycle is OK: $teff\n";
}

#second cycle on gravity: 
if ( $diff_iron > $grav_final*2 && $logg <=4.9 && $logg >=0.21) {
    $logg -= 0.2;
    printnewvalues();
    print "Correcting Log(g) (second cycle): $logg\n";
    exit(1);
}
elsif ( $diff_iron < -$grav_final*2 && $diff_iron>-2 && $logg <=4.9&& $logg >=0.21) {
    $logg += 0.2;
    printnewvalues();
    print "Correcting Log(g) (secon cycle): $logg\n";
    exit(1);
}
elsif ($logg >5.) { 
    $logg = 5.0;
    printnewvalues();
    print "Maximun value allowed for gravity: $logg\n";
    exit(1);
}elsif ($logg <0.21) { 
    $logg += 0.01;
    printnewvalues();
    print "Miminum value allowed for gravity: $logg\n";
    exit(1);
}
elsif ( $diff_iron >= -$grav_final*2 &&  $diff_iron <= $grav_final*2 && $logg <=5 && $logg >=0.21) {
     print "Log(g) for the second cycle is OK: $logg\n";
}




#second  cycle on  micro
if  ( $slope_rw > 2*$rw_final && $micro < 5.0  && $micro >0.1) {
    $micro += 0.05;
    printnewvalues();
    print "Correcting Microturbolence (second cycle): $micro\n";
    exit(1);
}
elsif ( $slope_rw < -2*$rw_final  && $micro < 5.0 && $micro >0.1 ) {
    $micro -= 0.05;
    printnewvalues();
    print "Correcting Microturbolence (second cycle): $micro\n";
    exit(1);}
elsif ( $slope_rw >= -2*$rw_final &&  $slope_rw <= 2*$rw_final  && $micro <= 5.0  && $micro >= 0.1) {
     print "Microturbolence for the second cycle is  OK: $micro\n";
}

$feh=$feh_sun;

if  ( $slope_ep > $ep_final*$p ) {
    $teff += 2;
    printnewvalues();
    print "Correcting Teff (third cycle): $teff\n";
    exit(1);
}
elsif ( $slope_ep < -$ep_final*$p  ) {
    $teff -= 2;
    printnewvalues();
    print "Correcting Teff (third cycle): $teff\n";
    exit(1);}
elsif ( $slope_ep >= -$ep_final*$p &&  $slope_ep <= $ep_final*$p ) {
     print "Teff  for the third cycle is  OK: $teff\n";
}
#third  cycle on  micro: this last cycle is set considering err_fe_I/RW_range  0.06/1.5=0.04 
if  ( $slope_rw > $rw_final*4*$p && $micro < 5.0 && $micro > 0.1) {
    $micro += 0.01;
    printnewvalues();
    print "Correcting Microturbolence (third cycle): $micro\n";
    exit(1);
}
elsif ( $slope_rw < -$rw_final*4*$p  && $micro < 5.0 &&  $micro > 0.1) {
    $micro -= 0.01;
    printnewvalues();
    print "Correcting Microturbolence (third cycle): $micro\n";
    exit(1);}
elsif ( $slope_rw >= -$rw_final*4*$p &&  $slope_rw <= $rw_final*4*$p  && $micro >= 5.0  && $micro <= 0.1) {
     print "Microturbolence for the third cycle is  OK: $micro\n";
}


#third cycle on gravity: this last cycle is set considering sqrt(err_feI**2+err_feII**2)
if ( $diff_iron > $grav_final*$p && $logg <=4.9 && $logg >=0.21) {
    $logg -= 0.01;
    printnewvalues();
    print "Correcting Log(g) (third cycle): $logg\n";
    exit(1);
}
elsif ( $diff_iron < -$grav_final*$p && $diff_iron>-2 && $logg <=4.9&& $logg >=0.21) {
    $logg += 0.01;
    printnewvalues();
    print "Correcting Log(g) (third cycle): $logg\n";
    exit(1);
}
elsif ($logg >5.) { 
    $logg = 5.0;
    printnewvalues();
    print "Maximun value allowed for gravity: $logg\n";
    exit(1);
}elsif ($logg <0.21) { 
    $logg += 0.01;
    printnewvalues();
    print "Miminum value allowed for gravity: $logg\n";
    exit(1);
}
elsif ( $diff_iron >= -$grav_final*$p &&  $diff_iron <= $grav_final*$p && $logg <=5 && $logg >=0.21) {
     print "Log(g) for the third cycle is OK: $logg\n";
}



#check the metallicity ond change from [Fe/H]=0 to the value measured by MOOG
$feh=$feh_sun;


print "$teff  $logg  $feh  $micro\n";


exit;

sub printnewvalues() {

    print OUT <<EOI;
$teff  $logg  $feh  $micro
EOI

}

