C *** Sample code to obtain the absolute visual magnitude of the Sun
C     along with the solar B-V and V-I colors from the bolometric
C     corrections derived from MARCS model atmospheres.  The ubvri90
C     transformations for the B, V, and I bandpasses (nfil = 3) have
C     been assumed. The result of this computation is:
C              M_V = 4.818, B-V = 0.637, and V-I = 0.698.
C
C *** A second test calculation is carried out for [Fe/H] = -0.5 and all
C     four dependencies of [alpha/Fe] with [Fe/H].  The result of this
C     computation is:
C           [Fe/H]  log g  Teff [alpha/Fe]   BC_B      BC_V    BC_I
C     std:   -0.50    4.5   5750   0.20     -0.6966  -0.1040  0.5989
C     m04:                        -0.40     -0.7099  -0.1051  0.6024
C     p00:                         0.00     -0.7021  -0.1043  0.6004
C     p04:                        +0.40     -0.6901  -0.1036  0.5977
C     interpolate in previous 3:   0.20     -0.6966  -0.1039  0.5991
C
C     The interpolated BCs in the tables for [alpha/Fe] = -0.4, 0.0, and
C     +0.04 (given in the last line) clearly reproduce those given in the
C     first line (assuming the standard variation of [alpha/Fe] with [Fe/H])
C     very well.
C
C *** This code must be compiled and linked with the "bcutil.for" library
C     of interpolation subroutines, which require the input data files
C     "bc_std.data", "bc_m04.data", "bc_p00.data" and "bc_p04.data".  These
C     files are assigned internally to units 30, 31, 32, and 33, respectively.
C
      real*4 a(3),x(3),bcstd(5),bcm04(5),bcp00(5),bcp04(5)
      character*6 fil(5)
 1001 format(/,' TEST1: [Fe/H] =',f6.2,', log g =',f6.3,', Teff =',f6.0,
     1 /,24x,'M_V =',f6.3,',',3x,'B-V =',f7.3,',',2x,'V-I =',f7.3,/)
 1002 format(/,' TEST2: [Fe/H]',2x,'log g',3x,'Teff',1x,'[alpha/Fe]',2x,
     1 'BC_B',5x,'BC_V',5x,'BC_I',//,7x,f6.2,2x,f6.3,2x,f6.0,2x,f5.2,
     2 4x,f6.4,3x,f6.4,3x,f6.4,/,4(/,31x,f5.2,4x,f6.4,3x,f6.4,3x,f6.4))
c *** specify the solar values of [Fe/H], log g, and Teff.
      fe=0.0
      gv=4.44
      temp=5777.
      teff=alog10(temp)
c *** read the BC transformations and interpolate to [Fe/H] = fe = 0.0.
      call getbc_std(0,fe,gv,teff,ebv,bcstd,fil,nbc)
c *** interpolate to obtain the BC values for log g = gv = 4.434 and
c *** Teff = temp = 5777 K.
      call getbc_std(1,fe,gv,teff,ebv,bcstd,fil,nbc)
c *** calculate the absolute B, V, and I magnitudes.
      absb=4.75-bcstd(1)
      absv=4.75-bcstd(2)
      absi=4.75-bcstd(3)
c *** calculate the B-V and V-I colors.
      bmv=absb-absv
      vmi=absv-absi
c *** write the results to unit 6.
      write(6,1001) fe,gv,temp,absv,bmv,vmi
c
c *** now carry out the second exercise for [Fe/H] = -0.5, [alpha/Fe] = 0.2
      fe=-0.5
      afe=0.2
      gv=4.5
      temp=5750.
      teff=alog10(temp)
c *** reinterpolate the bc_std tables to the new value of [Fe/H] = fe = -0.5
      call getbc_std(-1,fe,gv,teff,ebv,bcstd,fil,nbc)
c *** now perform the gv and Teff interpolation
      call getbc_std(1,fe,gv,teff,ebv,bcstd,fil,nbc)
c *** read the BC transformation tables for [alpha/Fe] = -0.4, 0.0, and 0.4
c *** and interpolate these table to [Fe/H] = fe = -0.5
      call getbc_m04(0,fe,gv,teff,ebv,bcm04,fil,nbc)
      call getbc_p00(0,fe,gv,teff,ebv,bcp00,fil,nbc)
      call getbc_p04(0,fe,gv,teff,ebv,bcp04,fil,nbc)
c *** now interpolate in these 3 tables to obtain the BC values for the
c *** input values of log g = gv = 4.5 and log Teff = log(5750)
      call getbc_m04(1,fe,gv,teff,ebv,bcm04,fil,nbc)
      call getbc_p00(1,fe,gv,teff,ebv,bcp00,fil,nbc)
      call getbc_p04(1,fe,gv,teff,ebv,bcp04,fil,nbc)
c *** perform a 3-point Lagrangian interpolation of the latter to obtain
c *** the BC values at [alpha/Fe] = 0.2 (to compare with the result of
c *** interpolating in bc_std.data
      x(1)=-0.4
      x(2)=0.0
      x(3)=0.4
      call lgran3(x,a,afe)
      bcbx=a(1)*bcm04(1)+a(2)*bcp00(1)+a(3)*bcp04(1)
      bcvx=a(1)*bcm04(2)+a(2)*bcp00(2)+a(3)*bcp04(2)
      bcix=a(1)*bcm04(3)+a(2)*bcp00(3)+a(3)*bcp04(3)
c *** the results written to unit 6 should be identical to those given
c *** for this exercise in the commented section near the top of this code.
      write(6,1002) fe,gv,temp,afe,bcstd(1),bcstd(2),bcstd(3),x(1),
     1  (bcm04(i),i=1,3),x(2),(bcp00(i),i=1,3),x(3),(bcp04(i),i=1,3),
     2  afe,bcbx,bcvx,bcix
      stop
      end
