! Code Aspects, version 2.0.
! Michel Fioc, 2014-4-15. 

module mod_variables

! Variables used by "example_simul" and "example_read".
! Variables which may be used only by "example_simul" are in 
! "mod_simul_catalogs.f90"; those which may only be used by "example_read"
! are in "mod_read_catalogs.f90".

  use mod_types, only : real_type, assoc_struct, coord_struct, prob_struct
  use mod_constants, only : pi

  implicit none

!######################################################################
! Catalogs.

! Sky area in steradians and default value thereof:
  real(kind=real_type) :: area_S = 4*pi
! (For real catalogs, `area_S` must be provided (cf. "example_read"). 
! For catalogs simulated (cf. "example_simul") with subroutine 
! `simul_catalogs`, `area_S` is set to its default value (all-sky simulation) 
! unless another value is provided.)

! Names of the catalogs containing the coordinates and positional uncertainties:
  character(len=72) :: K_u_file, K_p_file

! Cardinal numbers of $K$- and $K'$-sources:
  integer :: n_u, n_p

! Coordinates and positional uncertainties of $K$- and $K'$-sources:
  type(coord_struct), dimension(:), pointer :: coord_u => null(), &
       coord_p => null()

! Data on neighbors and possible counterparts:
  type(assoc_struct), dimension(:), pointer :: assoc_data_u => null()
  type(assoc_struct), dimension(:), pointer :: assoc_data_p => null()

!######################################################################
! Fraction of sources with a counterpart.

! Maximum-likelihood estimates of $f$ and $f'$ in the several-to-one and 
! one-to-several cases, respectively:
  real(kind=real_type) :: sto_f_u, ots_f_p

! Derived estimates of $f'$ and $f$ in the several-to-one and one-to-several 
! cases:
  real(kind=real_type) :: sto_f_p, ots_f_u

! Maximum-likelihood estimates of $f$ and $f'$ in the one-to-one case:
  real(kind=real_type) :: oto_f_u, oto_f_p

! 1-sigma uncertainties on `sto_f_u`, `ots_f_p` and `oto_f_u`:
  real(kind=real_type) :: std_dev_sto_f_u, std_dev_ots_f_p, std_dev_oto_f_u
! (Computed assuming that the positional uncertainties are known.)

!######################################################################
! Likelihoods.

! Maximum log-likelihoods in the several-to-one, one-to-several cases and
! one-to-one cases:
  real(kind=real_type) :: max_ln_sto_Lh, max_ln_ots_Lh, max_ln_oto_Lh

! Grid of (`f_u` [or `f_p`], `ln_oto_Lh`):
  integer :: n_grid ! Cardinal number of elements of `f_grid`.
  integer :: i_grid ! Ordinal number of an element of `f_grid`.
  real(kind=real_type), dimension(:), pointer :: f_grid => null(), &
       ln_oto_Lh_grid => null()

!######################################################################
! Probabilities.

! Names of the output files containing the probabilities of association:
  character(len=72) :: sto_prob_u_file, sto_prob_p_file, ots_prob_u_file, &
       ots_prob_p_file, oto_prob_u_file, oto_prob_p_file

! Probabilities of association:
  type(prob_struct), dimension(:), pointer :: sto_prob_u => null()
  type(prob_struct), dimension(:), pointer :: ots_prob_u => null()
  type(prob_struct), dimension(:), pointer :: oto_prob_u => null()
  type(prob_struct), dimension(:), pointer :: sto_prob_p => null()
  type(prob_struct), dimension(:), pointer :: ots_prob_p => null()
  type(prob_struct), dimension(:), pointer :: oto_prob_p => null()

!######################################################################
! Quantities used for checks. 
! The suffix `_sw` is used when $K$ and $K'$ are swapped.
! The suffix `_alt` refers to o:o likelihoods computed with `ln_oto_Lh_alt`.

  logical :: skip_checks
  real(kind=real_type) :: oto_f_u_sw, oto_f_p_sw, std_dev_oto_f_p_sw
  real(kind=real_type) :: max_ln_oto_Lh_alt, max_ln_oto_Lh_sw, &
       max_ln_oto_Lh_alt_sw
  character(len=72) :: oto_prob_u_file_sw, oto_prob_p_file_sw
  type(prob_struct), dimension(:), pointer :: oto_prob_u_sw => null()
  type(prob_struct), dimension(:), pointer :: oto_prob_p_sw => null()

  public

end module mod_variables
