#!/usr/bin/perl


use strict;
my (@average_abundance, @std_deviation, $rw_slope, $ep_slope, $waw_slope, $line);
my $filename="out2";  
my $slopefile="slope_out2";  
my $SILENT = 0; # = 1 per eliminare i messaggi

open (IN,$filename) || die;

while (<IN>) {    
  $line = $_;
  if ( /^average abundance/ ) {    
     print $line unless $SILENT;
     my (@ary)  = ($line =~ /= \s+ ([\-\d.]+) .* deviation \s+ = \s+ ([\-\d.]+) /x);
     if ($average_abundance[0]) {
        $average_abundance[1]=$ary[0];
     } else {
        $average_abundance[0]=$ary[0];
     }  
     if ($std_deviation[0]) {
        $std_deviation[1]=$ary[1];
     } else {
        $std_deviation[0]=$ary[1];
     }
     
     
  }
  
  if (/^R.W. correlation:/) {  
     print $line unless $SILENT;
     ($rw_slope) = ($line =~ /= \s+ ([\-\d.]+)/x);
  }#else{$rw_slope=0}   

  if (/^E.P. correlation:/) {  
     print $line unless $SILENT;
     ($ep_slope) = ($line =~ /= \s+ ([\-\d.]+)/x);
  }#else{$ep_slope=0}  
  
  if (/^wav. correl.:/) { 
     print $line unless $SILENT;
     ($waw_slope) = ($line =~  /= \s+ ([\d.E\-\+]+)/x);
  }#else{$waw_slope=0}
  
}                                        



print "\n\n\nabundance = $average_abundance[1],  standard_deviation = $std_deviation[1], rw_slope = $rw_slope, waw_slope = $waw_slope\n" unless $SILENT ;  

open (SLOPEFILE, ">$slopefile");
print SLOPEFILE  $average_abundance[1]," ",$std_deviation[1]," ",$ep_slope," ",$rw_slope," ",$waw_slope," ",  $average_abundance[0]," ",$std_deviation[0]," ","\n";  
