c@--------------------------------------------------------------------
c     @(#)tf.f      1.01      2013/06/9
c---------------------------------------------------------------------
      program lectsig
c==================================================================
c read  cross section
c
c!-----------------------------------------------------------------
      implicit double precision (a-h,o-z)
      character*24 ddate
      write(*,*)
      write(*,'(a)') '         N. Allard'
      write(*,'(a)') 'cross section from table.omg'
c-----get Line profiles
      call getprof
      end
c----------------
      subroutine getprof
      implicit double precision (a-h,o-z)
      parameter (NEMAX=360000)
      parameter (NNMAX=100)
      character*60 tabfile,line*72
      dimension plall(NEMAX,NNMAX)
      dimension   
     *     om(NEMAX),           !omega wing
     *     omc(NEMAX),          !omega core
     *     tlc(NEMAX),          !lorentzian as function of delta domega cm-1
     *     xl(NEMAX),           !lambda wing
     *     xlc(NEMAX),           !lambda  core
     *     pptot(NEMAX),         ! sum
     *     cdens(NNMAX),        ! coefficient density expansian
     *     pp(NNMAX)            !terme du developpement 
c-------------------------------------
      pi=3.141592653589793d0
c-----------------------------------------
      do i = 1,NEMAX
         xl(i) = 0.0d0
         xlc(i) = 0.0d0
         tlc(i) = 0.0d0
         om(i)= 0.0d0
         omc(i)= 0.0d0
         pptot(i)=0.0d0
      enddo
      do i = 1,NNMAX
         cdens(i)= 0.0d0
         pp(i)= 0.0d0
      enddo
c----------------------------------------------------------------
      read(*,'(a)') line
      read(*,*) dens_out
      write(*,*)dens_out
      read(*,'(a)') line
      read(*,*) domegc
      write(*,*)domegc
      read(*,'(a)') line
      read(*,*) nsf
      write(*,*)nsf
c--------------------------------------------
       read(*,'(a)') tabfile 
       write(*,'(a,a)') 'cross section from: ', tabfile
       open (10,file=tabfile,status='old')
            do i=1,100
               read(10,'(a)') line
               if(line(1:3).eq.'end') goto 20
               write(*,"('  >',a)") line
            enddo
 20   continue
      read(10,*)xlam_c,dens_in,vn,pir0f
      write(*,'(a,e12.5)') 
     *  ' pi*r0*fabs' ,pir0f
      write(*,'(a,e12.5,a)') 
     *  ' non perturbed wavelength ' ,xlam_c,' A'
      write(*,'(a,e12.5)') 
     *  ' vn' ,vn
         read(10,*)ntable,nexp
         read(10,*)wimp_cmi,dimp_cmi
         write(*,*)dens_in,domeg,domegc
         write(*,*)wimp_cmi,dimp_cmi
      nsf2=2*nsf-1
      write(*,'(a,2i12)')   'points for core:              ',
     *     nsf,nsf2
      write(*,'(a,i12)')   'points for table     ',
     *     ntable
      write(*,'(a,i12)')   'expansion order nexp    ',
     *     nexp
      write(*,'(a,2e12.5)') 'delta omega  [cm-1]:wing and  center ',  
     *     domeg,domegc 
      do i=1,ntable
         read(10,*)om(i),(plall(i,j),j=1,nexp)
      enddo
       close(10)
c-----------------------------------------
      vn1=dens_out/dens_in
      vns=vn1*vn
       xnorm=dexp(-vns)
      write(*,*)xnorm
      cdens(1)=vn1
      write(*,'(a,e12.5)') 
     *  ' cdens1' ,cdens(1)
c---------------------------------
      do i = 2,nexp
          cdens(i)=cdens(i-1)*cdens(1)
       enddo
c----------------------------------------------------------------
c-----------------------------------
            open(10,file='sigma_out.lam',status='unknown')
            open(11,file='sigma_out.omg',status='unknown')
c----------------------------------------------------
            do j=1,ntable
               pcour=0
                do i=1,nexp
                   pp(i)=   cdens(i)*plall(j,i)
                   pcour= pp(i)+pcour
                 enddo
               pptot(j)=pcour
              sig=pptot(j)*xnorm*pir0f
               xl(j)=1.0/(1.0e-8*om(j)+1.0/xlam_c)
               if(sig.gt.0.) then
                write(11,'(2e15.7)') om(j),sig
                write(10,'(2e15.7)') xl(j),sig
               endif
           enddo
           close(11)
           close(10)
c===============================================================
c---------------------------------------------------------
      write(*,'(a)') '         Lorentz'

c-----analytical Lorentz profile
c---
c----Lorentzienne impact pure
c 
       w=wimp_cmi*vn1
       w0=0.
       d=dimp_cmi*vn1
       d0=0.
            write(*,'(a,e15.5)') ' width [cm-1]   ', 
     *                 wimp_cmi
           write(*,'(a,e15.5)') ' w0   ',  w0
            write(*,'(a,e15.5)') ' shift [cm-1]   ', 
     *                 dimp_cmi
            write(*,'(a,e15.5)') ' d0   ',  d0
         ew=dexp(-w0)/pi
         wcd=w*dcos(d0)
         sd=dsin(d0)
         w2=w*w
c
c
c-----omega core
      do l=1,nsf2
         omc(l)=dble(l-nsf)*domegc
      enddo
         do  l=1,nsf2
            dmo=(omc(l)-d)
            dmo2=dmo*dmo
            onum=wcd+dmo*sd
            den=w2+dmo2
            tlc(l) = ew*onum*pir0f/den
         enddo
         open(10,file='lorentz_out.omg',status='unknown')
         write(10,'(2e15.7)') (omc(l),tlc(l),l=1,nsf2)
         close(10)
c-----profile on lambda scale
      open(11,file='lorentz_out.lam',status='unknown')
      do l=1,nsf2
         xlc(l)=1.0/(1.0e-8*omc(l)+1.0/xlam_c)
         write(11,'(e17.8,e14.5)') xlc(l),tlc(l)
      enddo
      close(11)
         return
         end







