;------------------------------------------------------------------------------;
function VGridPlot, pos
;------------------------------------------------------------------------------;
	common griddata, grds, gs, ds
;------------------------------------------------------------------------------;
	common procdata, pmod, proj
;------------------------------------------------------------------------------;
	common workdata, vxy, vmax, dv
;------------------------------------------------------------------------------;
	; define dopmap area
	!x.range = [min(vxy), max(vxy)]
	!y.range = [min(vxy), max(vxy)]
	plot, vxy, vxy, position = pos, xstyle = 5, ystyle = 5, /noerase, /nodata
	; add velocity coordinate grid
	if grds eq 1 then begin
		; cartesian velocity grid
		xt = '!5v!Dx!N !5[10!E3!N!5 km s!E-1!N!5]'
		yt = '!5v!Dy!N !5[10!E3!N!5 km s!E-1!N!5]'
		plot, vxy, vxy, position = pos, psym = 3, xstyle = 1, ystyle = 1, $
			xtit = xt, ytit = yt, /noerase, /nodata
		; add axes
		oplot, [-vmax, vmax], [0, 0], line = 1
		oplot, [0, 0], [-vmax, vmax], line = 1
	endif else begin
		chs = !x.charsize
		; polar velocity grid
		rt = '!5(v,!7h!5)!N !5[10!E3!N!5 km s!E-1!N!5, degrees]'
		deg = '!9' + String("45B) + '!X'
		rv = vmax + 0.5 * dv
		; nr of diagonals
		m = fix(90.0 / ds) - 1
		for i = 1, m do begin
			; deg increments
			d = ds * float(i)
			x = cos(d * !PI / 180.0) * rv
			y = tan(d * !PI / 180.0) * x
			oplot, [-x, x], [-y, y], line = 1
			oplot, [-x, x], [y, -y], line = 1
		endfor
		; circle grid with labels
		points = (2 * !PI / 99.0) * findgen(100)
		; base x, y position for grid circle label
		x = 0.025 * gs
		y = 0.085 * chs
		; default format for grid circle label
		ft = '(f3.1)'
		if gs lt 0.1 then ft = '(f4.2)'
		; nr of circles
		m = fix(rv / gs) + 1
		for i = 1, m do begin
			; set rp in increments of gs units
			rp = gs * (i - 1)
			; set circle radius according to projection method
			; standard
			if proj eq 0 then r = rp
			; inside-out linear
			if proj eq 1 then r = rv - rp
			; plot grid circle
			if proj gt 0 or r gt 0 then begin
				plots, r * cos(points), r * sin(points), line = 1, /data
				lbl = string(format = ft, rp)
				xyouts, x + r, -y, lbl, chars = chs, /data
			endif
		endfor
		if proj eq 0 then rv = vmax
		xyouts,  1.020 * rv,  0.025 * rv,   '0' + deg, chars = chs, align = 0.0
		xyouts, -0.025 * rv,  1.020 * rv,  '90' + deg, chars = chs, align = 1.0
		xyouts, -1.005 * rv, -0.075 * rv, '180' + deg, chars = chs, align = 1.0
		xyouts,  0.025 * rv, -1.075 * rv, '270' + deg, chars = chs, align = 0.0
		; add label
		xyouts, 0.0, -1.285 * vmax, rt, align = 0.5, /data
		; add axes
		ax = 1.185 * vmax
		plots, [-ax, ax], [0, 0], line = 1, /data
		plots, [0, 0], [-ax, ax], line = 1, /data
	endelse
;------------------------------------------------------------------------------;
	return, 0
end
;------------------------------------------------------------------------------;
