;------------------------------------------------------------------------------;
function SpectraPlot, pos, phr, vp0, ph0, sp0, ttl
;------------------------------------------------------------------------------;
	common procdata, pmod, proj
;------------------------------------------------------------------------------;
	if n_elements(ttl) eq 0 then ttl = ''
	; x label
	xt = ' Radial velocity !c !5v!Dr!N !5[10!E3!N!5 km s!E-1!N!5] '
	; ylabel
	if pmod eq 1 then begin
		yt = ' Spin phase !7u!5 '
	endif else begin
		yt = ' Orbital phase !7u!5 '
	endelse
	; define spectra area
	!y.range = [0, phr]
	plot, vp0, ph0, position = pos, xstyle = 5, ystyle = 5, /noerase, /nodata
	xl = !x.window(1) - !x.window(0)
	yl = !y.window(1) - !y.window(0)
	; display spectra
	tv, sp0, !x.window(0), !y.window(0), xsize = xl, ysize = yl, /norm
	plot, vp0, ph0, position = pos, psym = 3, xstyle = 1, ystyle = 1, $
		title = ttl, xtit = xt, ytit = yt, /noerase, /nodata, $
			xtickinterval = 1.0, xtickformat = '(I2)', $
				ytickinterval = 0.5, ytickformat = '(F3.1)'
;------------------------------------------------------------------------------;
	return, 0
end
;------------------------------------------------------------------------------;
