!******************************************************************************
!
!    mconstants.f95 (part of doptomog package v2.0)
!    Copyright (C) 2015  Enrico J. Kotze ejk@saao.ac.za
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!
!******************************************************************************
module mconstants
!******************************************************************************

!******************************************************************************
	implicit none
	! GC = gravitational constant [m**3 kg**(-1) s**(-2) or N m**2 kg**(-2)]
	real(kind(1d0)), parameter	::	GC = 6.673e-11
	! MSun = solar mass [kg]
	real(kind(1d0)), parameter	::	MSun = 1.9891e+30
	! RSun = solar radius [m]
	real(kind(1d0)), parameter	::	RSun = 6.9551e+8
	! MCh = Chandrasekhar mass [MSun]
	real(kind(1d0)), parameter	::	MCh = 1.44
	! cSI = speed of light [m/s]
	real(kind(1d0)), parameter	::	cSI = 2.99792458e+8
	! cCGS = speed of light [cm/s]
	real(kind(1d0)), parameter	::	cCGS = 2.99792458e+10
	! PI = yumyum
	real(kind(1d0)), parameter	::	PI = acos(-1d0)
	real(kind(1d0)), parameter	::	twoPI = 2d0 * PI
	! vf = m to 10**3 km factor
	real(kind(1d0)), parameter	::	vf = 1.e+6
!******************************************************************************

!******************************************************************************
end module mconstants
!******************************************************************************

!******************************************************************************
