!******************************************************************************
!
!    mbinarymodel.f95 (part of doptomog package v2.0)
!    Copyright (C) 2015  Enrico J. Kotze ejk@saao.ac.za
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!
!******************************************************************************
module mbinarymodel
!******************************************************************************

!******************************************************************************
	implicit none
!******************************************************************************

!******************************************************************************
	! general data:
	! cwd = current working directory
	character(len=255)				::	cwd = ''
	! srcpath = path to source folder
	character(len=255)				::	srcpath = ''
	! inpath = input path
	character(len=255)				::	inpath = ''
	! outpath = output path
	character(len=255)				::	outpath = ''
	! debug indicator
	logical							::	debug
	! IDL = IDL output indicator [0 = no, 1 = yes]
	integer							::	IDL
	! cmInd = centre of mass indicator [0 = use system com, 1 = use primary com]
	integer							::	cmInd
	
	! parameter data:
	! nDp = # of data points ...
	! nAd = # of accretion disc radii
	! nRl = # of points for Roche lobe arrays
	! nMax = max # of points for ballistic stream and Keplerian trace arrays
	integer, parameter	::	nDp = 360, nAd = 5, nRl = 720, nMax = 10000
	! eps = error margin for starting ballistic stream from L1
	! phaseMax = max phase for ballistic stream
	real(kind(1d0)), parameter	::	eps = 1e-3, phaseMax = 6d0
	! enumeration for sXYZ, vXYZ, magnD
	integer, parameter	::	r = 0, x = 1, y = 2, z = 3, vx = 4, vy = 5, vz = 6
	
	! input data: 'binarymodel.in'
	! mCV = magnetic cv indicator [0=no, 1=polar, 2=intermediate polar]
	integer							::	mCV
	! M1 = mass of primary in solar masses
	! qm = mass ratio M2/M1
	! inc = inclination angle of the system
	! Porb = orbital period of the system
	! Pspin = spin period of the primary
	! azE = azimuth angle at which ballistic stream ends
	real(kind(1d0))					::	M1, qm, inc, Porb, Pspin, azE
	! azMs = azimuth angle at which magnetic connection starts,
	! azMe = azimuth angle at which magnetic connection ends,
	! azMi = azimuth angle increment,
	! Psi = magnetic axis azimuth [towards(+)/away(-) secondary]
	! beta = magnetic axis co-latitude [towards(+)/away(-) secondary]
	real(kind(1d0))					::	azMs, azMe, azMi, Psi, beta
	! vDi = absolute velocity at inner disc [10**3 km/s]
	real(kind(1d0))					::	vDi

	! calculated data:
	integer											::	first
	! nF = # of output files
	! nBs = # of points for ballistic stream arrays
	! nBa = # of points for ballistic stream up to required azimuth
	integer											::	nF, nBs, nBa
	! thetaU: un-rotated, un-tilted dipole azimuthal angle (xy-plane)
	! rE = un-rotated, un-tilted dipole equatorial radius
	real(kind(1d0))									::	thetaU, rE
	! aa = binary separation
	! bvs = binary velocity scaling factor
	! sini = sin(i)
	! dv = delta velocity element
	real(kind(1d0))									::	aa, bvs, sini, dv
	! com = centre of mass
	! comSys = real centre of mass for system
	! comadj = velocity adjustment based on assumed velocity origin
	real(kind(1d0))									::	com, comSys, comAdj
	! R1 = radius of the primary
	! RL1 = distance from L1 to primary
	real(kind(1d0))									::	R1, RL1
	! vKmax = max Keplerian velocity
	! vFFmax = max free fall velocity from infinity
	! vFFmaxL1 = max free fall velocity from L1
	real(kind(1d0))									::	vKmax, vFFmax, vFFmaxL1
	! standard polar velocity coordinates
	real(kind(1d0))									::	theta, v
	! rMag = magnetosphere radius
	! vKMag = Keplerian velocity at rMag
	real(kind(1d0))									::	rMag, vKMag
	! rAd = accretion disc radii
	! hAd = accretion disc height at radii
	real(kind(1d0)), dimension(nAd)					::	rAd, hAd = 0.
	! theta360 = 360 degree array
	real(kind(1d0)), dimension(0:nDp)				::	theta360
	! xAd = x position of accretion disc radii
	! yAd = y position of accretion disc radii
	! vxAd = x velocity of accretion disc radii
	! vyAd = y velocity of accretion disc radii
	real(kind(1d0)), dimension(nAd, 0:nDp)			::	xAd, yAd, vxAd, vyAd
	! multi-dimensional arrays
	! rotate = rotate matrix
	! tilt = tilt matrix
	! roTilt = rotate and tilt matrix
	real(kind(1d0)), dimension(3,3)					::	rotate, tilt, roTilt
	! vCOM = centres of mass velocity coordinates
	! sCOM = centres of mass spatial coordinates
	real(kind(1d0)), dimension(0:2,2)				::	vCOM
	real(kind(1d0)), dimension(0:2,2)				::	sCOM
	! sMagnD = spatial coordinates of magnetic dipole connection
	! vMagnD = velocity coordinates of magnetic dipole connection
	real(kind(1d0)), dimension(3,1)					::	sMagnD, vMagnD
	! magnD = spatial and velocity coordinates of magnetic dipole line
	real(kind(1d0)), dimension(6,nDp)				::	magnD
	! allocatable 1-dimensional arrays
	! chi = polar angle array for the Roche lobes (from M1-direction)
	! phi = azimuth array for the Roche lobes (from orbital plane)
	real(kind(1d0)), allocatable, dimension(:)		::	chi, phi
	! xBs = x position of ballistic stream
	! yBs = y position of ballistic stream
	! vxBs = x velocity of ballistic stream
	! vyBs = y velocity of ballistic stream
	real(kind(1d0)), allocatable, dimension(:)		::	xBs, yBs, vxBs, vyBs
	! vxKt = x velocity of Keplerian trace
	! vyKt = y velocity of Keplerian trace
	real(kind(1d0)), allocatable, dimension(:)		::	vxKt, vyKt
	! azBs = ballistic stream azimuth from line M1-M2
	real(kind(1d0)), allocatable, dimension(:)		::	azBs
	! allocatable 2-dimensional arrays
	! rRl = radius array for the Roche lobes
	! xRl(1,n) = x position of primary's (M1) Roche lobe
	! yRl(1,n) = y position of primary's (M1) Roche lobe
	! xRl(2,n) = x position of secondary's (M2) Roche lobe
	! yRl(2,n) = y position of secondary's (M2) Roche lobe
	real(kind(1d0)), allocatable, dimension(:,:)	::	rRl, xRl, yRl

!******************************************************************************

!******************************************************************************
contains
!******************************************************************************

!******************************************************************************


!******************************************************************************

!******************************************************************************
end module mbinarymodel
!******************************************************************************

!******************************************************************************
