function statusinterpreter,n

;+
; NAME:
;	STATUSINTERPRETER
;
; PURPOSE:
;	This function maps the status code of MPFITFUN to a text
;	explaining its meaning.
;
; CALLING SEQUENCE:
;	text = STATUSINTERPRETER(Status)
;
; INPUTS:
;	Status:	The integer status code returned by MPFITFUN.
;
; OUTPUTS:
;	This function returns a string explaining the meaning of the status
;	code MPFITFUN set.
;
; EXAMPLE:
;       textmeaning = STATUSINTERPRETER(1)
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; map the interger status code of MPFITFUN to its text explanation
case n of
	0: return,'Failure: improper input parameters'
	1: return,'both actual and predicted relative reductions in the sum of squares are at most FTOL'
	2: return,'relative error between two consecutive iterates is at most XTOL'
	3: return,'conditions for STATUS = 1 and STATUS = 2 both hold, i.e. both actual and predicted relative reductions in the sum of squares are at most FTOL and relative error between two consecutive iterates is at most XTOL'
	4: return,'the cosine of the angle between fvec and any column of the jacobian is at most GTOL in absolute value.'
	5: return,'the maximum number of iterations has been reached'
	6: return,'FTOL is too small. no further reduction in the sum of squares is possible.'
	7: return,'XTOL is too small. no further improvement in the approximate solution x is possible.'
	8: return,'GTOL is too small. fvec is orthogonal to the columns of the jacobian to machine precision.'
else: return,'Unknown status condition'
endcase
end