pro rddat,file,wave,spec,error,header,phoenix=phoenix
;+
; NAME:
;	RDDAT
;
; PURPOSE:
;	This procedure reads VLT/X-Shooter spectra.
;
; CALLING SEQUENCE:
;	RDDAT,File,Wave,Spec,Error,Header
;
; INPUTS:
;	File:	Scalar string containing complete path to file
;	
; KEYWORD PARAMETERS:
;	PHOENIX:  Set this keyword if you want to read spectra from
;		  the Göttingen Spectral Library by PHOENIX
;		  (http://phoenix.astro.physik.uni-goettingen.de/)
;
; OUTPUTS:
;	Wave:	  Wavelength array in Angstrom
;	Spec:	  Flux array

;
; OPTIONAL OUTPUTS:
;	Error:	  Error array
;	Header:	  Header of the fits file
;
; EXAMPLE:
;	If you just want to have wavelength and flux use
;       rddat,'/here/is/the/data/SCI_SLIT_MERGE1D_VIS.fits',wave,spec
;
;	If you also want error and header use
;       rddat,'/here/is/the/data/SCI_SLIT_MERGE1D_VIS.fits',wave,spec,error,header
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; check the input parameters
if n_params() lt 3 then begin
    message,/info,'Syntax: rddat,file,wave,spec,error,header  (file=string)'
    retall
endif

; read data and header
spec = mrdfits(file,0,/silent)
if keyword_set(phoenix) then spec=spec*1.d-8
head = headfits(file)

if n_params() ge 4 then error=mrdfits(file,1,/silent)
if n_params() eq 5 then header=head

;start wavelength
startwave = sxpar(head,'CRVAL1')

;wavelength bin size
wavebin = sxpar(head,'CDELT1')

; wavelength array
wave = dblarr(n_elements(spec))
for i = 0L,n_elements(spec)-1 do wave[i] = startwave + double(i)*wavebin
if keyword_set(phoenix) then begin
    wa=exp(wave)
    vactoair,wa
    wave=wa
endif else wave=wave*10.d
end