function getobjects
;+
; NAME:
;	GETOBJECTS
;
; PURPOSE:
;	This function extracts the names of the objects to use the TELLREM
;	package on.
;
; CALLING SEQUENCE:
;	Result = GETOBJECTS()
;
; INPUTS:
;	None.
;
; OUTPUTS:
;	This function returns a string array of the folder names located
;	in the path containing the reduced spectra specified in the
;	info file provide to LOADTELLREMINFO. It expects these to be the
;	object names which will be added as auxiliary information during
;	the further run of TELLREM.
;
; COMMON BLOCKS:
;       TELLREM_INFO: This common block contains relevant folder names and strings
;	              for running tellrem. It has to be initialised by running
;		      LOADTELLREMINFO.
;
; EXAMPLE:
;       objects = GETOBJECTS()
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
common tellrem_info

; extract folder names
objects=file_search(spectrafolder,'*',/test_directory)
; just get the name itself without absolute path
for i=0,n_elements(objects)-1 do begin
    obj=strsplit(objects[i],'/',/extract)
    objects[i]=obj[n_elements(obj)-1]
endfor
; return them
return,objects
end