;------------------------------------------------------------------------------;
pro SpectraRead, inf
;------------------------------------------------------------------------------;
	; read spectra file into common blocks
;------------------------------------------------------------------------------;
	common procdata, pmod, proj
;------------------------------------------------------------------------------;
	common pardata, vm, vf, gam, w0, abs, atm, src, ih, nrm, ns, wd, am, al, ac
;------------------------------------------------------------------------------;
	common specdata, npb, nvp, phase, dphase, vp, spi, sp, spri, spr, spf, sprf
;------------------------------------------------------------------------------;
	get_lun, lun
	; open spectra file
	openr, lun, inf
	; read period fold indicator, m to 10**3 km factor
	readf, lun, pmod, vf
	src = ''
	; read spectra parameters
	readf, lun, vs, gam, w0, abs, atm, src
	src = strcompress(src)
	; read array sizes
	readf, lun, npb, nvp
	; array dimensions
	phase = fltarr(npb)
	dphase = fltarr(npb)
	vp = fltarr(nvp)
	wp = fltarr(nvp)
	sp = fltarr(npb, nvp)
	; read phases
	readf, lun, phase
	; from radians to orbits
	phase = phase / 2 / !pi
	; fold between 0 and 1
	phase = phase mod 1
	index = where(phase lt 0)
	if index(0) ne -1 then phase(index) = phase(index) + 1
	; read delta phases
	readf, lun, dphase
	; from radians to orbits
	dphase = dphase / 2 / !pi
	; read velocity points
	readf, lun, vp
	; delta velocity
	dvp = vp(1) - vp(0)
	; correction from left boundary to centre of bin
	vp = vp - dvp / 2
	; read spectra
	readf, lun, sp
	spri = -1
	; read wavelength points
	readf, lun, wp
	close, lun
	free_lun, lun
;	print, inf, ' read'
;------------------------------------------------------------------------------;
	return
end
;------------------------------------------------------------------------------;
