;------------------------------------------------------------------------------;
pro DopTomogRead, inf
;------------------------------------------------------------------------------;
	; read doptomog file into common blocks
;------------------------------------------------------------------------------;
	common procdata, pmod, proj
;------------------------------------------------------------------------------;
	common pardata, vm, vf, gam, w0, abs, atm, src, ih, nrm, ns, wd, am, al, ac
;------------------------------------------------------------------------------;
	common specdata, npb, nvp, phase, dphase, vp, spi, sp, spri, spr, spf, sprf
;------------------------------------------------------------------------------;
	common mapdata, np, mapi, map, dmapi, dmap, mmapi, mmap
;------------------------------------------------------------------------------;
	get_lun, lun
	; open doptomog file
	openr, lun, inf
	; read max absolute velocity, m to 10**3 km factor, nr of pixels,
	; period fold indicator, projection method
	readf, lun, vm, vf, np, pmod, proj
	; read input spectra indicator, array sizes
	readf, lun, spi, nt, npb, nvp
	; if input spectra are present...
	if spi gt 0 then begin
		src = ''
		; read spectra parameters
		readf, lun, vs, gam, w0, abs, atm, src
		src = strcompress(src)
		; array dimensions
		phase = fltarr(npb)
		dphase = fltarr(npb)
		vp = fltarr(nvp)
		sp = fltarr(npb, nvp)
		; read phases
		readf, lun, phase
		; from radians to orbits
		phase = phase / 2 / !pi
		; fold between 0 and 1
		phase = phase mod 1
		index = where(phase lt 0)
		if index(0) ne -1 then phase(index) = phase(index) + 1
		; read delta phases
		readf, lun, dphase
		; from radians to orbits
		dphase = dphase / 2 / !pi
		; read velocity points
		readf, lun, vp
		; delta velocity
		dvp = vp(1) - vp(0)
		; correction from left boundary to centre of bin
		vp = vp - dvp / 2
		; read input spectra
		readf, lun, sp
		; read reconstructed spectra indicator
		readf, lun, spri
		; if reconstructed spectra are present...
		if spri gt 0 then begin
			; array dimensions
			spr = fltarr(npb, nvp)
			; read reconstructed spectra
			readf, lun, spr
		endif
	endif
	; read dopmap indicator, array sizes
	readf, lun, mapi, nt, np
	; if dopmap(s) is present...
	if mapi gt 0 then begin
		; read dopmap parameters
		readf, lun, ih, nrm, ns, al, wd, am, ac
		; array dimensions
		map = fltarr(np, np)
		; read dopmap
		readf, lun, map
		; read delta map indicator, array sizes
		readf, lun, dmapi
		; if delta dopmaps are present...
		if dmapi gt 0 then begin
			dmap = fltarr(np, np, dmapi)
			readf, lun, dmap
		endif
	endif
	; read modulation map indicator
	readf, lun, mmapi
	; if modulation maps are present...
	if mmapi gt 0 then begin
		mmap = fltarr(np, np, mmapi)
		readf, lun, mmap
	endif
	close, lun
	free_lun, lun
;	print, inf, ' read'
;------------------------------------------------------------------------------;
	return
end
;------------------------------------------------------------------------------;
