;+
; NAME:
;         p3d_misc_errors
;
;         $Id: p3d_misc_errors.pro 79 2010-03-04 14:24:25Z christersandin $
;
; PURPOSE:
;         The purpose of this routine is to display an error message once an
;         error handler has been setup using CATCH. The error is shown, and an
;         open file is closed (optionally).
;
; AUTHOR:
;         Christer Sandin
;         Astrophysikalisches Institut Potsdam (AIP)
;         An der Sternwarte 16
;         D-14482 Potsdam, GERMANY
;
; COPYRIGHT:
;         p3d: a general data-reduction tool for fiber-fed IFSs
;
;         Copyright 2009,2010 Astrophysikalisches Institut Potsdam (AIP)
;
;         This program is free software; you can redistribute it and/or modify
;         it under the terms of the GNU General Public License as published by
;         the Free Software Foundation; either version 3 of the License, or
;         (at your option) any later version.
;
;         This program is distributed in the hope that it will be useful, but
;         WITHOUT ANY WARRANTY; without even the implied warranty of
;         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;         General Public License for more details.
;
;         You should have received a copy of the GNU General Public License
;         along with this program; if not, see <http://www.gnu.org/licenses>.
;
;         Additional permission under GNU GPL version 3 section 7
;
;         If you modify this Program, or any covered work, by linking or
;         combining it with IDL (or a modified version of that library),
;         containing parts covered by the terms of the IDL license, the
;         licensors of this Program grant you additional permission to convey
;         the resulting work.
;
; CATEGORY:
;         p3d :: auxiliary routines
;
; CALLING SEQUENCE:
;         p3d_misc_errors,error_status,rname=,unit=,topwid=
;
; INPUTS:
;         error_status    - An integer with the error code.
;
; KEYWORD PARAMETERS:
;         rname ['p3d_misc_logger']
;                         - The name of the routine where the error occurred.
;         unit            - A scalar integer with the value of a file unit,
;                           that, if it is open, is closed.
;         topwid          - If set, then the error message (iff ERROR) is shown
;                           using a dialog instead of printing the message on
;                           the console.
;
; COMMON BLOCKS:
;         none
;
; SIDE EFFECTS:
;         none
;
; RESTRICTIONS:
;         IDL version 6.2 or higher is required (~).
;
; MODIFICATION HISTORY:
;         10.09.2009 - Introduced this header. /CS
;
;-
PRO p3d_misc_errors,error_status,rname=rname,unit=unit,topwid=topwid
  compile_opt hidden,IDL2

  if ~n_elements(topwid) then topwid=0L
  if ~n_elements(rname) then rname='p3d_misc_errors: '

  ;;========================================------------------------------
  ;; Acting on errors:

  if widget_info(topwid,/valid_id) then begin
    errmsg=[rname+'Error status: '+strtrim(error_status,2L)+ $
            ' :: Error message: '+!error_state.msg]
    ret=dialog_message(errmsg,/error,dialog_parent=topwid, $
            title=rname+'Error!',/center)
  endif else begin
    errmsg=[rname+'Error status: '+strtrim(error_status,2L), $
            rname+'Error message: '+!error_state.msg]
    for i=0,1 do print,errmsg[i]
  endelse

  if n_elements(unit) eq 1L then begin
    tmp=fstat(unit)
    if tmp.open then free_lun,unit
  endif

  return
END ;;; procedure: p3d_misc_errors
