#!/bin/bash
################################################################################
# remember: chmod 755 6-idl.doptomog.sh
################################################################################
# set parent directory
prtdir=$(pwd)
# set code directory
cdedir=$prtdir/code
# set script directory
scpdir=$prtdir/scripts
# set sources directory
srcdir=$prtdir/sources
################################################################################
# get source folder name
result=1
while [ $result -eq 1 ]; do
	read -p "Source folder name (e.g., mcv, etc.)? "
	if [ ! -z "$REPLY" ]; then
		# call validatedir.sh to check if source folder exists
		source $scpdir/shell/validatedir.sh $srcdir $REPLY 1
		result=$?
	fi
done
# set source
src=$REPLY
# set source folder path
srcfldr=$srcdir/$src
################################################################################
# output directory
# call validatedir.sh to check if doptomog output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out/ doptomog 1
if [ "$?" -eq 1 ]; then exit; fi
# call validatedir.sh to check if binarymodel output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out/binarymodel/ idl 1
if [ "$?" -eq 1 ]; then
	read -p "Produce tomograms without 2d velocity overlay (y/n)? "
	if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
		ovr=0
	else
		echo "Execute '5-exec.pbinarymodel.sh' to calculate binary model and go again! Bye for now!"
		source $scpdir/shell/continue.sh 1
		exit
	fi
else
	ovr=1
fi
################################################################################
# go to idl script folder...
cd $scpdir/idl
# copy parameter file to idl script folder
cp $srcfldr/in/binarymodel.in .
# set binarymodel source path
mdir=$srcfldr/out/binarymodel/idl/
################################################################################
# process tomogram files
# set doptomog source path
sdir=$srcfldr/out/doptomog/
# loop for standard and inside-out projections
for ((i=0; i<=1; i++))
do
	if [ $i -eq 0 ]; then mth="standard"; fi
	if [ $i -eq 1 ]; then mth="inside-out"; fi
	read -p "Execute 'doptomog' IDL script for $src $mth projection (y/n)? "
	if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
		# set doptomog source file
		inf='doptomog.'$i'.out'
		# execute idl script
		echo "executing 'doptomogplot.pro' in IDL for $src $mth projection..."
		cmd="sdir='$sdir', mdir='$mdir', inf='$inf', suf='.$i', ovr=$ovr"
		idl -e "DopTomogPlot, $cmd"
		# display output
		read -p "Display output (y/n)? "
		if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
			if [ $ovr -eq 1 ]; then
				gnome-open $srcfldr/out/doptomog/dopmap.$i.vmod.ps &
			else
				gnome-open $srcfldr/out/doptomog/dopmap.$i.ps &
			fi
		fi
	fi
done
################################################################################
# process flux modulation mapping files
# call validatedir.sh to check if fluxmodmap doptomog output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out/doptomog fluxmodmap 0
if [ "$?" -eq 0 ]; then
	# set fluxmodmap doptomog source path
	sdir=$srcfldr/out/doptomog/fluxmodmap/
	# loop for standard and inside-out projections
	for ((i=0; i<=1; i++))
	do
		if [ $i -eq 0 ]; then mth="standard"; fi
		if [ $i -eq 1 ]; then mth="inside-out"; fi
		read -p "Execute 'doptomog' IDL script for $src $mth projection for flux modulation mapping (y/n)? "
		if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
			# IDL script flags
			amf=0.1
			read -p "Amplitude filter (amf), i.e., display phase of maximum flux where amplitudes > amf * maximum amplitude (default = 0.1)? "
			if [ ! -z "$REPLY" ] && (( "$REPLY" >= "0" )); then
				amf=$REPLY
			fi
			echo "Amplitude filter (amf) used: "$amf
			# set doptomog source file
			inf="fluxmodmap.$i.out"
			# execute idl script
			echo "executing 'doptomogplot.pro' in IDL for $src $mth projection..."
			cmd="sdir='$sdir', mdir='$mdir', inf='$inf', suf='.$i', ovr=$ovr, amf=$amf"
			idl -e "DopTomogPlot, $cmd"
			# display output
			read -p "Display output (y/n)? "
			if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
				if [ $ovr -eq 1 ]; then
					gnome-open $srcfldr/out/doptomog/fluxmodmap/dopmap.$i.vmod.ps &
					gnome-open $srcfldr/out/doptomog/fluxmodmap/moduamp.$i.vmod.ps &
					gnome-open $srcfldr/out/doptomog/fluxmodmap/moduphap.$i.vmod.ps &
				else
					gnome-open $srcfldr/out/doptomog/fluxmodmap/dopmap.$i.ps &
					gnome-open $srcfldr/out/doptomog/fluxmodmap/moduamp.$i.ps &
					gnome-open $srcfldr/out/doptomog/fluxmodmap/moduphap.$i.ps &
				fi
			fi
		fi
	done
fi
################################################################################
# process half-phase tomogram files
# call validatedir.sh to check if halfphases doptomog output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out/doptomog halfphases 0
if [ "$?" -eq 0 ]; then
	# set halfphases doptomog source path
	sdir=$srcfldr/out/doptomog/halfphases/
	# loop for standard and inside-out projections
	for ((i=0; i<=1; i++))
	do
		if [ $i -eq 0 ]; then mth="standard"; fi
		if [ $i -eq 1 ]; then mth="inside-out"; fi
		# get nr of halfphases files
		nr=$(head -n 1 $srcfldr/out/doptomog/halfphases/halfphases.$i.out)
		n="$[$nr]"
		read -p "Execute 'doptomog' IDL script for $src $mth projection for $n half-phases (y/n)? "
		if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
			n="$[$n-1]"
			for ((k=0; k<=$n; k++))
			do
				# set doptomog source file
				inf="doptomog.$i.$k.out"
				# execute idl script
				echo "$k : executing 'doptomogplot.pro' in IDL for $src $mth projection..."
				cmd="sdir='$sdir', mdir='$mdir', inf='$inf', suf='.$i.$k', ovr=$ovr"
				idl -e "DopTomogPlot, $cmd"
				# display output
				read -p "$k : Display output (y/n)? "
				if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
					if [ $ovr -eq 1 ]; then
						gnome-open $srcfldr/out/doptomog/halfphases/dopmap.$i.$k.vmod.ps &
					else
						gnome-open $srcfldr/out/doptomog/halfphases/dopmap.$i.$k.ps &
					fi
				fi
			done
		fi
	done
fi
################################################################################
# remove parameter file from idl script folder
rm binarymodel.in
################################################################################
# back to parent directory
cd $prtdir
################################################################################
# continue (exit)
source $scpdir/shell/continue.sh 1
################################################################################
