

; Bin a power spectrum square map into one dimensional power spectrum

pro cmn2cb, map_b, map_cmn, cb, sigma_b

if n_params() lt 1 then begin
   message, /info, "Calling sequence:"
   print, "cmn2cb, map_b, map_cmn, cb"
   return
endif

w  = where( map_b ne !undef)
m1 = map_b[w]
m2 = map_cmn[w]

h       = histogram( m1, bin=1.0d0, reverse_ind=R)
cb      = double(h*0.0d0)
sigma_b = double(h*0.0d0)
for i=0, n_elements(h)-1 do begin
   IF r(i) NE r(i+1) then begin
      cb[i] = avg( m2[R[R[i] : R[i+1]-1]])
      ;;sigma_b[i] = stddev( m2[R[R[i] : R[i+1]-1]])
      sigma_b[i] = stddev( m2[R[R[i] : R[i+1]-1]])/sqrt((r[i+1]-r[i]))
   endif
endfor

end
