;------------------------------------------------------------------------------;
pro VModelRead
;------------------------------------------------------------------------------;
	common inputdata, mdirs, rlbs, bals, mags, dscs, keps
;------------------------------------------------------------------------------;
	common workdata, vxy, vmax, dv
;------------------------------------------------------------------------------;
	common ovrdata, vcom, vl1, vl2, vbs, vbc, vms, vmsl, vmc, vdi, vdo, $
		vkt, vkc, nc, mcv
;------------------------------------------------------------------------------;
	rp = vmax + 0.5 * dv
	ni = 0
	get_lun, lun
;------------------------------------------------------------------------------;
	; load binary model file
	file = 'binarymodel.in'
	openr, lun, file
	readf, lun, mcv
	close, lun
;------------------------------------------------------------------------------;
	if rlbs eq 1 then begin
;------------------------------------------------------------------------------;
		vcom = fltarr(3, 7)
		; load system centre of mass
		file = mdirs + 'vCOM.out'
		openr, lun, file
		readf, lun, x, y, z, t, p, r ;, rp
		vcom(0, 0) = x
		vcom(0, 1) = y
		vcom(0, 2) = z
		vcom(0, 3) = t
		vcom(0, 4) = p
		vcom(0, 5) = r
		vcom(0, 6) = max([rp - r, 0]) ;rp
		close, lun
;------------------------------------------------------------------------------;
		; load binary centres of mass
		file = mdirs + 'vBinary.out'
		; count lines: centres of mass
		spawn, 'wc ' + file, count
		reads, count, ni
		openr, lun, file
		for i = 1, ni do begin
			readf, lun, x, y, z, t, p, r ;, rp
			vcom(i, 0) = x
			vcom(i, 1) = y
			vcom(i, 2) = z
			vcom(i, 3) = t
			vcom(i, 4) = p
			vcom(i, 5) = r
			vcom(i, 6) = max([rp - r, 0]) ;rp
		endfor
		close, lun
;------------------------------------------------------------------------------;
		; load M1-lobe
		file = mdirs + 'vPrimary.out'
		; count lines: M1-lobe
		spawn, 'wc ' + file, count
		reads, count, ni
		vl1 = fltarr(ni, 7)
		openr, lun, file
		for i = 0, ni - 1 do begin
			readf, lun, x, y, z, t, p, r ;, rp
			vl1(i, 0) = x
			vl1(i, 1) = y
			vl1(i, 2) = z
			vl1(i, 3) = t
			vl1(i, 4) = p
			vl1(i, 5) = r
			vl1(i, 6) = max([rp - r, 0]) ;rp
		endfor
		close, lun
;------------------------------------------------------------------------------;
		; load M2-lobe
		file = mdirs + 'vSecondary.out'
		; count lines: M2-lobe
		spawn, 'wc ' + file, count
		reads, count, ni
		vl2 = fltarr(ni, 7)
		openr, lun, file
		for i = 0, ni - 1 do begin
			readf, lun, x, y, z, t, p, r ;, rp
			vl2(i, 0) = x
			vl2(i, 1) = y
			vl2(i, 2) = z
			vl2(i, 3) = t
			vl2(i, 4) = p
			vl2(i, 5) = r
			vl2(i, 6) = max([rp - r, 0]) ;rp
		endfor
		close, lun
;------------------------------------------------------------------------------;
	endif
;------------------------------------------------------------------------------;
	if bals eq 1 then begin
;------------------------------------------------------------------------------;
		; load ballistic stream
		file = mdirs + 'vStreamBal.out'
		; count lines: ballistic stream
		spawn, 'wc ' + file, count
		reads, count, ni
		vbs = fltarr(ni, 7)
		openr, lun, file
		for i = 0, ni - 1 do begin
			readf, lun, x, y, z, t, p, r ;, rp
			vbs(i, 0) = x
			vbs(i, 1) = y
			vbs(i, 2) = z
			vbs(i, 3) = t
			vbs(i, 4) = p
			vbs(i, 5) = r
			vbs(i, 6) = max([rp - r, 0]) ;rp
		endfor
		close, lun
;------------------------------------------------------------------------------;
		; load inner and outer edges of disc
		if mcv eq 0 then begin
;------------------------------------------------------------------------------;
			; inner edge of disc
			file = mdirs + 'vDiscInner.out'
			; count lines: inner disc edge
			spawn, 'wc ' + file, count
			reads, count, ni
			vdi = fltarr(ni, 7)
			openr, lun, file
			for i = 0, ni - 1 do begin
				readf, lun, x, y, z, t, p, r ;, rp
				vdi(i, 0) = x
				vdi(i, 1) = y
				vdi(i, 2) = z
				vdi(i, 3) = t
				vdi(i, 4) = p
				vdi(i, 5) = r
				vdi(i, 6) = max([rp - r, 0]) ;rp
			endfor
			close, lun
			; outer edge of disc
			file = mdirs + 'vDiscOuter.out'
			; count lines: outer disc edge
			spawn, 'wc ' + file, count
			reads, count, ni
			vdo = fltarr(ni, 7)
			openr, lun, file
			for i = 0, ni - 1 do begin
				readf, lun, x, y, z, t, p, r ;, rp
				vdo(i, 0) = x
				vdo(i, 1) = y
				vdo(i, 2) = z
				vdo(i, 3) = t
				vdo(i, 4) = p
				vdo(i, 5) = r
				vdo(i, 6) = max([rp - r, 0]) ;rp
			endfor
			close, lun
;------------------------------------------------------------------------------;
			; load keplerian trace
			if keps eq 1 then begin
;------------------------------------------------------------------------------;
				; keplerian trace
				file = mdirs + 'vKeplerian.out'
				; count lines: keplerian trace
				spawn, 'wc ' + file, count
				reads, count, ni
				vkt = fltarr(ni, 7)
				openr, lun, file
				for i = 0, ni - 1 do begin
					readf, lun, x, y, z, t, p, r ;, rp
					vkt(i, 0) = x
					vkt(i, 1) = y
					vkt(i, 2) = z
					vkt(i, 3) = t
					vkt(i, 4) = p
					vkt(i, 5) = r
					vkt(i, 6) = max([rp - r, 0]) ;rp
				endfor
				close, lun
				; keplerian-ballistic connections
				file = mdirs + 'vKeplerianConnect.out'
				; count lines: keplerian connections
				spawn, 'wc ' + file, count
				reads, count, ni
				nc = ni
				vkc = fltarr(ni, 7)
				openr, lun, file
				for i = 0, ni - 1 do begin
					readf, lun, x, y, z, t, p, r ;, rp
					vkc(i, 0) = x
					vkc(i, 1) = y
					vkc(i, 2) = z
					vkc(i, 3) = t
					vkc(i, 4) = p
					vkc(i, 5) = r
					vkc(i, 6) = max([rp - r, 0]) ;rp
				endfor
				close, lun
;------------------------------------------------------------------------------;
			endif
;------------------------------------------------------------------------------;
		endif
;------------------------------------------------------------------------------;
		; load ballistic-magnetic connections, magnetic stream
		if mcv ne 0 and mags ne 0 then begin
;------------------------------------------------------------------------------;
			; ballistic connections
			file = mdirs + 'vStreamBalConnect.out'
			; count lines: ballistic connections
			spawn, 'wc ' + file, count
			reads, count, ni
			vbc = fltarr(ni, 7)
			openr, lun, file
			for i = 0, ni - 1 do begin
				readf, lun, x, y, z, t, p, r ;, rp
				vbc(i, 0) = x
				vbc(i, 1) = y
				vbc(i, 2) = z
				vbc(i, 3) = t
				vbc(i, 4) = p
				vbc(i, 5) = r
				vbc(i, 6) = max([rp - r, 0]) ;rp
			endfor
			close, lun
			; magnetic connections
			file = mdirs + 'vStreamMagConnect.out'
			; count lines: magnetic connections
			spawn, 'wc ' + file, count
			reads, count, ni
			nc = ni
			vmc = fltarr(ni, 7)
			openr, lun, file
			for i = 0, ni - 1 do begin
				readf, lun, x, y, z, t, p, r ;, rp
				vmc(i, 0) = x
				vmc(i, 1) = y
				vmc(i, 2) = z
				vmc(i, 3) = t
				vmc(i, 4) = p
				vmc(i, 5) = r
				vmc(i, 6) = max([rp - r, 0]) ;rp
			endfor
			close, lun
			; magnetic stream
			file = mdirs + 'vStreamMag.out'
			; count lines: magnetic stream
			spawn, 'wc ' + file, count
			reads, count, ni
			vms = fltarr(ni, 7)
			openr, lun, file
			for i = 0, ni - 1 do begin
				readf, lun, x, y, z, t, p, r ;, rp
				vms(i, 0) = x
				vms(i, 1) = y
				vms(i, 2) = z
				vms(i, 3) = t
				vms(i, 4) = p
				vms(i, 5) = r
				vms(i, 6) = max([rp - r, 0]) ;rp
			endfor
			close, lun
			if mcv eq 2 then begin
				; magnetic stream - lower curtain
				file = mdirs + 'vStreamMag.1.out'
				; count lines: magnetic stream
				spawn, 'wc ' + file, count
				reads, count, ni
				vmsl = fltarr(ni, 7)
				openr, lun, file
				for i = 0, ni - 1 do begin
					readf, lun, x, y, z, t, p, r ;, rp
					vmsl(i, 0) = x
					vmsl(i, 1) = y
					vmsl(i, 2) = z
					vmsl(i, 3) = t
					vmsl(i, 4) = p
					vmsl(i, 5) = r
					vmsl(i, 6) = max([rp - r, 0]) ;rp
				endfor
				close, lun
			endif
;------------------------------------------------------------------------------;
		endif
;------------------------------------------------------------------------------;
	endif
;------------------------------------------------------------------------------;
	free_lun, lun
	return
end
;------------------------------------------------------------------------------;
