;------------------------------------------------------------------------------;
pro SpectraTrailed, sdir = sdir, inf = inf, phr = phr, $
	ctb = ctb, eps = eps, psc = psc, dsp = dsp
;------------------------------------------------------------------------------;
; plot trailed spectra
;------------------------------------------------------------------------------;
; sdir	:	map source directory; default ''
; inf	:	map source file; default 'spectrailed.out'
; phr	:	phase range; default 2
; ctb	:	color table; default 15 (stern-special)
; eps	:	output encapsulated postscript; default 1 (yes)
; psc	:	output postscript in color; default 1 (yes)
; dsp	:	display plots on screen; default 1 (yes)
;------------------------------------------------------------------------------;
	common procdata, pmod, proj
;------------------------------------------------------------------------------;
	common pardata, vm, vf, gam, w0, abs, atm, src, ih, nrm, ns, wd, am, al, ac
;------------------------------------------------------------------------------;
	common specdata, npb, nvp, phase, dphase, vp, spi, sp, spri, spr, spf, sprf
;------------------------------------------------------------------------------;
	; check keywords, set defaults
	if n_elements(sdir) eq 0 then sdir = ''
	if n_elements(inf) eq 0 then inf = 'spectrailed.out'
	if n_elements(phr) eq 0 then phr = 2
	if n_elements(ctb) eq 0 then ctb = 15
	if n_elements(eps) eq 0 then eps = 1
	if n_elements(psc) eq 0 then psc = 1
	if n_elements(dsp) eq 0 then dsp = 1
;------------------------------------------------------------------------------;
	; load color table
	loadct, ctb, /silent
	; max no of colors of display
	mcol = !d.table_size - 1
;------------------------------------------------------------------------------;
	; constants
	pi = 3.1415926535897932
;------------------------------------------------------------------------------;
	; read input
	SpectraRead, sdir + inf
;------------------------------------------------------------------------------;
	; phase and dphase in radians
	phase = 2.0 * pi * phase
	dphase = 2.0 * pi * dphase
	ph0 = phase
	; spectra preparations
	result = SpectraPrep(phr)
	if result ne 0 then return
	; scale velocity points with velocity units
	vp0 = vp / vf
	; maximum intensity from spectra
	spm = max(spf)
	; spectra
	sp0 = spf / spm
	sp0 = rotate((mcol * (1 - sp0) > 0) < mcol, 4)
	xsf = float(fix(vp0(nvp - 1))) / 2.0
	if xsf lt 1.0 then xsf = 1.0
;------------------------------------------------------------------------------;
	; set plotting to postscript
	set_plot, 'ps'
	; set up device
	device, font_size = 12, bits_per_pixel = 8
	; set encapsulated postscript if necessary
	if eps eq 1 then device, /encaps else device, encaps = 0
	; set color postscript if necessary
	if psc eq 1 then device, /color else device, color = 0
	; set up device for spectra output
	if phr eq 1.0 then device, /portrait, xsize = 7.5 * xsf, ysize = 10
	if phr eq 2.0 then device, /portrait, xsize = 10.0 * xsf, ysize = 15
	; separate ps file for trailed spectra
	file = sdir + 'spectrailed.ps'
	device, filename = file
;------------------------------------------------------------------------------;
	; increase plot definition
	!p.thick = 3
	!p.charthick = 3
	!p.charsize = 1.25
	!x.charsize = 1
	!y.charsize = 1
;------------------------------------------------------------------------------;
	; offsets and xy-sizes
	if phr eq 1.0 then begin
		xof = 0.225
		xsi = 0.65 * xsf
		yof = 0.20
		ysi = 0.75
	endif else begin
		xof = 0.175
		xsi = 0.70 * xsf
		yof = 0.15
		ysi = 0.80
	endelse
	; position
	pos = [xof, yof, xof + xsi, yof + ysi]
	result = SpectraPlot(pos, phr, vp0, ph0, sp0)
	if result ne 0 then return
	device, /close
	if eps eq 1 then spawn, "sed -i '$ i\showpage' " + file
;------------------------------------------------------------------------------;
	!p.thick = 1
	!p.charthick = 1
	!p.charsize = 1
;------------------------------------------------------------------------------;
	; display screen output
	if dsp eq 1 then begin
		set_plot, 'x'
		device, decomposed = 0
		loadct, ctb, /silent
		xsi = 300 * xsf
		ysi = 600
		window, 0, xsize = xsi, ysize = ysi, colors = mcol
		; spectra
		tv, congrid(sp0, xsi - 1, ysi - 1), 0, 0
		key = ''
		read, 'Press <Enter> to continue... ', key
	endif
;------------------------------------------------------------------------------;
	return
end
;------------------------------------------------------------------------------;
