#******************************************************************************
# 3d position coordinates: interacting binary
#******************************************************************************
reset
#******************************************************************************
pagelayout = 1
#******************************************************************************
# set terminal
call "terminal.gnu"
#******************************************************************************
# set functions
call "functions.gnu"
#******************************************************************************
# widths and colours for lines
pw = 0.5; pc = "blue"			# primary
sw = 0.5; sc = "red"			# secondary
bw = 4.0; bc = "dark-orange"	# ballistic flow
dw = 0.5; dc = "orange"			# disc flow
mw = 1.0; mc = "dark-yellow"	# magnetic flow
aw = 0.5; ac = "cyan"			# magnetic axes
xw = 0.5; xc = "green"			# axes
#******************************************************************************
# plot files
fileS = join2(modpath, "s3DSecondary.out")
if (exSec == 1) fileS = join2(modpath, "sCOM.out")
fileD = join2(modpath, "s3DDisc.out")
fileB = join2(modpath, "sStreamBal.out")
fileM = join2(modpath, "sStreamMag.out")
#fileM = join2(modpath, "s3DDipole.out")
#******************************************************************************
# load binary parameters
load join2(modpath, "pBinary")
#******************************************************************************
# calculations and overrides
# R1 = radius of primary
#R1 = 5 * R1
# xAdj = x-adjustment to centre of mass for plot
xAdj = comInd * com
# s = display axes
s = dAxes
#******************************************************************************
# output file / folder
if (terminal == 1) \
	set output join3(modpath, file, ".ps");
if (terminal == 2) \
	folder = join2(modpath, "eps"); \
	syscmd = join2("mkdir -p ", folder); \
	system syscmd;
if (terminal == 3) \
	folder = join2(modpath, "pngs"); \
	syscmd = join2("mkdir -p ", folder); \
	system syscmd;
#******************************************************************************
# get rid of some stuff
unset key; unset tics; unset border; unset colorbox
# general settings
set parametric
set angles degrees; set mapping cartesian
set view equal xyz; set xyplane at 0
set samples 100; set isosamples 18
set hidden3d front trianglepattern 3
set style data lines
#******************************************************************************
# ranges
rx = 1.5; ry = 0.6; rz = 0.3
set xrange [-rx:rx]; set yrange [-ry:ry]; set zrange [-rz:rz]
set urange [0:360]; set vrange [-90:90]
#set urange [-90:90]; set vrange [0:360]
set origin x0, y0
#******************************************************************************
# loop variables
n = 0.0
start = 90.0
if (terminal == 1) \
	step = 45.0; \
	end = -270.0;
if (terminal == 2) \
	step = 15.0; \
	end = -270.0;
if (terminal == 3) \
	step = 10.0; \
	end = -270.0;
if (terminal == 9) \
	step = 90.0; \
	end = 90.0;
t = start
#******************************************************************************
call "splot.gnu"
#******************************************************************************
unset parametric
#******************************************************************************
