!******************************************************************************
!
!    mspectra.f95 (part of doptomog package v2.0)
!    Copyright (C) 2015  Enrico J. Kotze ejk@saao.ac.za
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!
!******************************************************************************
module mspectra
!******************************************************************************

!******************************************************************************
	! general data:
	! cwd = current working directory
	character(len=255)								::	cwd = ''
	! srcpath = path to source folder
	character(len=255)								::	srcpath = ''
	! inpath = input path (folder containing spectrum files)
	character(len=255)								::	inpath = ''
	! outpath = output path
	character(len=255)								::	outpath = ''
	! stype = spectra process indicator
	integer											::	stype = 0
	! ios = status returned for read statement
	integer											::	ios = 0
	! tab character
	character(len=1)								::	tab = char(9)
	! debug indicator
	logical											::	debug

	! parameter data:
	! parameters for spectra process
	integer, parameter								::	prepare = 0
	integer, parameter								::	extract = 1
	integer, parameter								::	trailed = 2

	! input data:
	! specList = name of file containing list of spectra
	character(len=20)								::	specList = ''
	! specDir = name of folder containing list of spectra and spectra files
	character(len=20)								::	specDir = ''
	! pmod = period fold indicator (0 = orbital, 1 = spin, 2 = extract spin)
	integer											::	pmod = 0
	! fcol = column nr of spectrum file name in spectra list
	integer											::	fcol = 0
	! pcol = column nr of phase value
	integer											::	pcol = 0
	! dcol = column nr of phase interval (0 if not present)
	integer											::	dcol = 0
	! wcol = column nr of wavelength in spectrum file
	integer											::	wcol = 0
	! scol = column nr of spectrum in spectrum file
	integer											::	scol = 0
	! dpha = fixed phase interval for the exposure times (0 if not relevant)
	real(kind(1d0))									::	dpha = 0d0
	! rebin = rebin spectra indicator (0 = no, 1 = yes)
	integer											::	rebin = 0
	! nbin = nr of bins for rebinning
	integer											::	nbin = 0
	! K1 = K1 velocity [m/s]
	real(kind(1d0))									::	K1 = 0d0
	! K1pho = K1 phase-offset [phase]
	real(kind(1d0))									::	K1pho = 0d0
	! gam = gamma velocity [m/s]
	real(kind(1d0))									::	gam = 0d0
	! w0 = rest wavelength of line [Angstroms]
	real(kind(1d0))									::	w0 = 0d0
	! cw = wavelength range around w0 to keep (0 to keep everything)
	real(kind(1d0))									::	cw = 0d0
	! dw = wavelength range around w0 (w0 - dw < w < w0 + dw)
	real(kind(1d0))									::	dw = 0d0
	! df1 = dw factor for inner range
	real(kind(1d0))									::	df1 = 0d0
	! df2 = dw factor for outer range
	real(kind(1d0))									::	df2 = 0d0
	! if abl=1, invert line (for absorption lines)
	integer											::	abl = 0
	! if atm=1, take out atmospheric absorption
	integer											::	atm = 0
	! nho = nr of half orbit spectra to extract
	integer											::	nho = 0
	
	! calculated data:
	! dpham = average phase interval
	real(kind(1d0))									::	dpham = 0d0
	! npe = nr of phase entries
	integer											::	npe = 0
	! npr = reduced nr of phase entries
	integer											::	npr = 0
	! nws = nr of wavelength and spectrum entries
	integer											::	nws = 0
	! nve = nr of velocity entries
	integer											::	nve = 0
	! mcol = maximum columns in specific file
	integer											::	mcol = 0
	integer											::	i0, i1, nwl
	real(kind(1d0))									::	w1, w2, v1, v2, vs
	real(kind(1d0))									::	ca1, ca2, cla

	! array data:
	character(len=80), dimension(:), allocatable	::	sfile
	character(len=80), dimension(:), allocatable	::	entries
	
	real(kind(1d0)), dimension(2) 					::	wr, wc1, wc2
	real(kind(1d0)), dimension(:), allocatable		::	phase, dphase, pIndexM
	real(kind(1d0)), dimension(:), allocatable		::	tphase, tdphase
	real(kind(1d0)), dimension(:), allocatable		::	wlj, wl1, wl, wp, vp, bl
	real(kind(1d0)), dimension(:), allocatable		::	indx, ind, iw
	real(kind(1d0)), dimension(:), allocatable		::	tra, trb, trbc, clev
	real(kind(1d0)), dimension(:), allocatable		::	specj, spec1
	real(kind(1d0)), dimension(:,:), allocatable	::	spec
	real(kind(1d0)), dimension(:,:), allocatable	::	trw, trwc, spout, tspout

!******************************************************************************

!******************************************************************************
contains
!******************************************************************************

!******************************************************************************


!******************************************************************************

!******************************************************************************
end module mspectra
!******************************************************************************

!******************************************************************************
