# -*- coding: utf-8 -*-
"""
Created on Fri Apr 17 10:28:57 2015

@author: adrienkuntz
"""
import numpy as np


### In kernelsc.pyx
h = 0.679
H0 = 100e3                                           #hubble constant in m/s/Mpc * h
cl = 3e8                                             #speed of light in m/s
omegalambda0 = 0.7                                 #omega parameters
omegam0 = 1 - omegalambda0
zCMB = 1090                                          #redshift of the CMB
alpha = 2.2                                         #parameters for dn/dz found by fitting the real dN/dz ; see fit_dNdz.py
lambda_ = 0.781                                      #parameters for dn/dz
beta = 3.36                                           #parameters for dn/dz
z0 = 0.973                                           #parameters for dn/dz (version CFHTLenS)
sn = 1.                                              #parameter for the magnification bias

chinum = 3000                                       #size for the storage of the values of Wk and Wg



### in M.py

G = 6.67e-11                                         #Gravitational constant
delta_sc = 1.686                                     #critical density of spherical collapse
rhobar = 3*H0**2 / (8*np.pi*G) * omegam0 / 2e30 * (3.09e22)    #average comoving density of matter of the universe (Solar mass/h * (h/Mpc)**3)
q = 0.75
p = 0.3                                              #parameters for the Sheth & Tormen function
delta_nl = np.exp(1/3.*np.log(340))                  #ratio between the virial radius and the initial radius of a halo in the spherical collapse model
a2 = -17/21.
a3 = 341/567.

mnum = 1000
mmin = 1e-6
xmax = 10.                                            #Maximum x for the integration of WTH(x)
nspectral = 0.96                                             #Spectral index for the initial power spectrum


knum = 300                                           #number of points for the storage of the values of M in arrays
kmin_log = -3
kmax_log = 3

zmin = 0
zmax = 2.5
znum = 30
ztab = np.linspace(zmin, zmax, znum)