!/*-----------------------------------------------------------------*/
!/*! 
!  \file f90arome.h
!  \brief fortran 77/90/95 binding interface
!         requires a fortran compiler with the standard fortran 77.
!
!  \author  G. Boue
!           EXOEarths, Centro de Astrofisica, Universidade do Porto.
!
!   Copyright (C) 2012, CAUP
!   email of the author : gwenael.boue@astro.up.pt
! 
!   This work has been supported by the European Research Council/European
!   Community under the FP7 through Starting Grant agreement number 239953, as
!   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
!   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
!   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
!   SFRH/BPD/81084/2011.
!
!
!*/
!/*-----------------------------------------------------------------*/

!/*----------------------------------------------------------------*/
!/* License of the file :
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!*/
!/*----------------------------------------------------------------*/


       !/* orbit module */
       integer f90arome_new_orbit
       external f90arome_free_orbit
       integer f90arome_set_orbit_eo
       integer f90arome_set_orbit_kh
       double precision f90arome_get_orbit_transit_time
       integer f90arome_get_orbit_xyz
       integer f90arome_mget_orbit_xyz
       
       !/* arome module */
       integer f90arome_alloc_quad
       external f90arome_alloc_quad
       integer f90arome_alloc_nl
       external f90arome_alloc_nl
       integer f90arome_reset_quad
       external f90arome_reset_quad
       integer f90arome_reset_nl
       external f90arome_reset_nl
       external f90arome_free
       integer f90arome_set_lineprofile
       external f90arome_set_lineprofile
       integer f90arome_set_planet
       external f90arome_set_planet
       integer f90arome_init_ccf
       external f90arome_init_ccf
       integer f90arome_init_iodine
       external f90arome_init_iodine
       integer f90arome_calc_fvpbetap
       external f90arome_calc_fvpbetap
       double precision f90arome_get_rm_ccf
       external f90arome_get_rm_ccf
       double precision f90arome_get_rm_iodine
       external f90arome_get_rm_iodine
       double precision f90arome_get_rm_mean
       external f90arome_get_rm_mean
       integer f90arome_get_rm_ccf_e
       external f90arome_get_rm_ccf_e
       integer f90arome_get_rm_iodine_e
       external f90arome_get_rm_iodine_e
       integer f90arome_get_rm_mean_e
       external f90arome_get_rm_mean_e
       double precision f90arome_get_flux
       external f90arome_get_flux
       double precision f90arome_get_vp
       external f90arome_get_vp
       double precision f90arome_get_betapr
       external f90arome_get_betapr
       double precision f90arome_get_betapt
       external f90arome_get_betapt
       integer f90arome_set_flux
       external f90arome_set_flux
       integer f90arome_set_vp
       external f90arome_set_vp
       integer f90arome_set_betapr
       external f90arome_set_betapr
       integer f90arome_set_betapt
       external f90arome_set_betapt
       external f90arome_set_exit_on_error
       external f90arome_set_continue_on_error
       external f90arome_set_func_on_error
       integer f90arome_set_gcf_itmax
       external f90arome_set_gcf_itmax
       integer f90arome_set_gcf_eps
       external f90arome_set_gcf_eps
       integer f90arome_set_gcf_fpmin
       external f90arome_set_gcf_fpmin
       integer f90arome_set_gser_itmax
       external f90arome_set_gser_itmax
       integer f90arome_set_gser_eps
       external f90arome_set_gser_eps
       integer f90arome_set_qtrap_eps
       external f90arome_set_qtrap_eps
       integer f90arome_set_qtrap_jmax
       external f90arome_set_qtrap_jmax
       integer f90arome_malloc
       external f90arome_malloc
       external f90arome_mfree
       integer f90arome_mcalc_fvpbetap
       external f90arome_mcalc_fvpbetap
       integer f90arome_mget_flux
       external f90arome_mget_flux
       integer f90arome_mget_vp
       external f90arome_mget_vp
       integer f90arome_mget_betapr
       external f90arome_mget_betapr
       integer f90arome_mget_betapt
       external f90arome_mget_betapt
       integer f90arome_mset_flux
       external f90arome_mset_flux
       integer f90arome_mset_vp
       external f90arome_mset_vp
       integer f90arome_mset_betapr
       external f90arome_mset_betapr
       integer f90arome_mset_betapt
       external f90arome_mset_betapt
       integer f90arome_mget_rm_ccf
       external f90arome_mget_rm_ccf
       integer f90arome_mget_rm_iodine
       external f90arome_mget_rm_iodine
       integer f90arome_mget_rm_mean
       external f90arome_mget_rm_mean
