#!/bin/csh


# CoRoT Detrend Algorithm
# Mislis et al. 2010

# Main script

  
gfortran add.f
mv a.out add

gfortran aver.f
mv a.out aver

gfortran norm.f
mv a.out norm

gfortran norm2.f
mv a.out norm2

gfortran bad.f
mv a.out bad

gfortran fit.f
mv a.out fit

gfortran all.f
mv a.out all

gfortran sd.f
mv a.out sd

clear
echo
echo
echo '                               CoRoT De-TRENDING ALGORITHM'
echo
echo
echo

# ========================= SPLIT 3 COLORS

foreach i (CoRoT*.txt)
set filename = $i:r
echo '                     SPLIT IN 3 COLORS LIGHTCURVE : '$filename

awk '{print $2, $5, $6, $4}' $i > $filename.red
awk '{print $2, $7, $8, $4}' $i > $filename.green
awk '{print $2, $9, $10, $4}' $i > $filename.blue

# ======================== BAD FLAG POINTS REMOVING 



clear
echo
echo
echo '                               CoRoT De-TRENDING ALGORITHM'
echo
echo
echo


set filename = $i:r
echo '                     BAD POINTS REMOVING-STEP (RED)  FILE : '$filename

set redd = $filename.red

awk '{print $1}' $redd > time
awk '{print $2}' $redd > flux
awk '{print $3}' $redd > error
awk '{print $4}' $redd > flag

set time = `cat time`
echo $#time > nnt
./bad
mv fort.9 $filename.R.cor




clear
echo
echo
echo '                               CoRoT De-TRENDING ALGORITHM'
echo
echo
echo

set filename = $i:r
echo '                     BAD POINTS REMOVING-STEP (GREEN)  FILE : '$filename

set green = $filename.green

awk '{print $1}' $green > time
awk '{print $2}' $green > flux
awk '{print $3}' $green > error
awk '{print $4}' $green > flag

set time = `cat time`
echo $#time > nnt
./bad
mv fort.9 $filename.G.cor





clear
echo
echo
echo '                               CoRoT De-TRENDING ALGORITHM'
echo
echo
echo

set filename = $i:r
echo '                     BAD POINTS REMOVING-STEP (BLUE)  FILE : '$filename

set blue = $filename.blue

awk '{print $1}' $blue > time
awk '{print $2}' $blue > flux
awk '{print $3}' $blue > error
awk '{print $4}' $blue > flag

set time = `cat time`
echo $#time > nnt
./bad
mv fort.9 $filename.B.cor

awk '{print $2}' $filename.R.cor > mmean
set mm = `cat mmean`
set nn = $#mm

awk '{SUM +=$2 } END {print SUM/'$nn'}' $filename.R.cor > mmean
awk '{print $1}' $filename.R.cor > Rtime

# ==================================== SPLIT COLORS TO DAYS

#gfortran split.f
rm -f noCoRoT*
clear
echo
echo
echo 'SPLIT SUB-LC'
echo
foreach nv ( $filename*.cor) 
set fgfg = $nv:r
echo 'FILE : '$fgfg
awk '{print $1}' $nv > ttm
awk '{print $2}' $nv > fflx
awk '{print $3}' $nv > errorr

set ttm = `cat ttm`
set fflx = `cat fflx`
set errorr = `cat errorr`
set trno = $#ttm

if ( $trno <= '10000' ) then
set stp = 60
set trmp = 60
else
set stp = 2000
set trmp = 2000
endif

set sts = 1
set wws = $#ttm
set l = 1

while ($sts <= $wws) 
while ($sts <= $stp)
if ( $stp <= $wws ) then
echo $ttm[$sts]' '$fflx[$sts]' '$errorr[$sts] >> no$fgfg.$l
else
endif

@ sts = $sts + 1
end
@ stp = $stp + $trmp
@ l = $l + 1
end 
end 


# ==================================== NON-LINEAR FITTING
#foreach vv (*$filename*.cor)

#set filenamer = $vv:r
#cp $vv temp 
#awk '{print $1}' temp > time 
#awk '{print $2}' temp > flux 
#awk '{print $3}' temp > error 
#set nnn = `cat time`
#echo $#nnn > non

#echo 'f(x) = a+b*x+c*x**2+d*x**3' > fit.csh
#echo 'fit f(x) "temp" via a, b, c, d' >> fit.csh
#gnuplot fit.csh
#awk '{print $3}' fit.log > tmp
#rm -f fit.log
#set no = `cat tmp`
#set fl = $#no 
#@ fl = $fl - 8 
#echo $no[$fl] > info
#@ fl = $fl + 1
#echo $no[$fl] >> info
#@ fl = $fl + 1
#echo $no[$fl] >> info
#@ fl = $fl + 1
#echo $no[$fl] >> info
#./fit
#mv fort.9 $filenamer.fin
#end 

#foreach vva (CoRoT*.fin)
#set gfg = $vva:r
#mv $vva $gfg.cor
#end 

rm -f a.out fit.log temp error time flux
rm -f info tmp non fit.csh



rm -f CoRoT*.red
rm -f CoRoT*.green
rm -f CoRoT*.blue
rm -f flux time error flag

set l = 0
foreach zz (no$filename.R.*)
@ l = $l + 1
end 
set stt = 1

while ( $stt <= $l )

mv no$filename.R.$stt $filename.R.cor
mv no$filename.G.$stt $filename.G.cor
mv no$filename.B.$stt $filename.B.cor

awk '{print $1}' $filename.R.cor > time
awk '{print $2}' $filename.R.cor > fluxr
awk '{print $2}' $filename.G.cor > fluxg
awk '{print $2}' $filename.B.cor > fluxb

set nono = `cat time`
echo $#nono > nono
./norm
mv fort.7 $filename.R.cor
mv fort.8 $filename.G.cor
mv fort.9 $filename.B.cor

mv fort.10 rmeanr
rm -f fluxr fluxg fluxb nono

awk '{print $1}' $filename.R.cor > time
awk '{print $2}' $filename.R.cor > rflux
awk '{print $2}' $filename.G.cor > gflux
awk '{print $2}' $filename.B.cor > bflux
set nnn = `cat time`
echo $#nnn > no

./aver

mv fort.7 rflux
mv fort.8 gflux
mv fort.9 bflux
set mme = `cat fort.10`
echo $mme >> mmean

echo '1000000.0' > sd1
set stst = 1
set enen = 10
clear
echo ' FILENAME No : '$stt
echo '        R filter                   G filter                  B filter'

while ( $stst <= $enen) 
echo
echo

./add
mv fort.7 rflux
mv fort.8 gflux
mv fort.9 bflux
set gkg = `cat rflux`
echo $#gkg > npoi

./sd
set sd2 = `cat fort.10`
set anss = `cat fort.11`

if ( $anss == y ) then

cp rflux old_rflux
echo $sd2 > sd1
else
@ stst = 11
endif

@ stst = $stst + 1
end 
mv old_rflux rflux

./norm2
mv fort.7 $filename.R.cor.$stt
rm -f $filename.G.cor
rm -f $filename.B.cor



rm -f bflux gflux  newnew  no rflux rmean nnt 
clear
echo
echo
echo
@ stt = $stt + 1

end 

set l = 0
foreach zz ( $filename.R.cor.*)
@ l = $l + 1
end 
set stt = 1
rm -f result

set rz = 1
while ( $stt <= $l )
echo $stt
set oo = `cat $filename.R.cor.$stt`
set enn = $#oo
@ rz = 1

while ( $rz <= $enn ) 
echo $oo[$rz] >> result
@ rz = $rz + 1
end 
@ stt = $stt + 1

end 

rm -f CoRoT*.R.cor.*
set rt = `cat result`
echo $#rt > nono

./all
mv fort.9 $filename.R.cor

end 

rm -f add bad norm2 norm aver fit Rtime ttm nono errorr fflx
rm -f all mmean result time rmeanr sd1 npoi fort.*  sd
clear

