/*-----------------------------------------------------------------*/
/*! 
  \file cmset.c 
  \brief Check the function arome_mset_flux 

  \author  G. Boue
           EXOEarths, Centro de Astrofisica, Universidade do Porto.

   Copyright (C) 2012, CAUP
   email of the author : gwenael.boue@astro.up.pt

   This work has been supported by the European Research Council/European
   Community under the FP7 through Starting Grant agreement number 239953, as
   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
   SFRH/BPD/81084/2011.


  History:                                                                
*/
/*-----------------------------------------------------------------*/

/*----------------------------------------------------------------*/
/* License of the file :

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*----------------------------------------------------------------*/
#include <stdio.h>
#include <math.h>
#include "arome.h"


/*************************/
/* main routine          */
/* just a test           */
/*************************/
int main(int argc, char **argv)
{
   const int ncoord = 20;
   double tab_flux_in[ncoord], tab_flux_out[ncoord];
   t_arome *parome;
   int status = 0;
   
   /* planet's coordinates */
   for(int k=0; k<ncoord; k++)
   {
     tab_flux_in[k] = cos((double)k);
   }
   
   arome_set_exit_on_error();
   
   /* allocation of the ARoME structure */
   parome = arome_alloc_quad(0.6,0.0);
   
   /* to use the vectorial routines, it is necessary to allocate the necessary space */
   status += arome_malloc(ncoord, parome);
   
   /* set the flux */
   status += arome_mset_flux(tab_flux_in, ncoord, parome);
   
   /* get the flux */
   status += arome_mget_flux(parome, ncoord, tab_flux_out);
   
   for(int k=0; k<ncoord; k++)
   {
     if (fabs(tab_flux_in[k]-tab_flux_out[k])>1.e-10)
     {
       fprintf(stderr,"ERROR: flux_out[%d] (%.15E) is not equal to flux_in[%d] (%.15E).\n",
             k, tab_flux_out[k], k, tab_flux_in[k]);
       return 1;
     }
   }
   
   /* release memory */
   arome_mfree(parome);
   arome_free(parome);
   
   return status;
}
