;; p3d_tool_makevm
;;
;; $Id: p3d_tool_makevm.pro 111 2010-03-15 09:52:23Z christersandin $
;;
;; --
;;
;; p3d: a general data-reduction tool for fiber-fed IFSs
;;
;; Copyright 2009,2010 Astrophysikalisches Institut Potsdam (AIP)
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, see <http://www.gnu.org/licenses>.
;;
;; Additional permission under GNU GPL version 3 section 7
;;
;; If you modify this Program, or any covered work, by linking or
;; combining it with IDL (or a modified version of that library),
;; containing parts covered by the terms of the IDL license, the
;; licensors of this Program grant you additional permission to convey
;; the resulting work.
;;
;; --
;;
;; The purpose of this script is to make a .sav-file that can be used
;; with the IDL Virtual Machine. Thereby it is possible to run p3d
;; without using an IDL license.
;;
;; This script can be used with the Linux, Solaris, and OS X platforms.
;; To use this script start IDL (using a license) in the p3d root
;; directory and then call this script as: @p3d_tool_makevm.
;; It is also possible to use the shell script
;; '${p3d_path}/vm/p3d_tool_makevm.sh',
;; which automatically ensures that the script is started from the
;; correct directory.
;;
;; If more routines are added to the p3d package then they must
;; be added to this routine as well if p3d should continue to work
;; with the IDL Virtual Machine.
;;
;; NOTE! When this script is executed the (required) programs of
;;       "The IDL Astronomy User's Library"
;;       (cf. http://idlastro.gsfc.nasa.gov/homepage.html) must be
;;       present under the 'contrib/astro-lib' directory in the p3d
;;       root. It is not necessary to move the files there, a soft link
;;       suffices:
;;          cd <p3d_path>; ln -s <astro-lib_path> contrib/astro-lib'
;;       The necessary files can, optionally, be downloaded with the
;;       supplied script p3d_acquire_xtools.sh.
;;
;; NOTE! The used routines of astro-lib must be fairly recent. The
;;       use of arbitrarily old routines could result in a program
;;       that cannot be used with the Virtual Machine. Specifically,
;;       one routine of astro-lib, that is frequently used in p3d, is
;;       readcol.pro. This routine used to call the routine EXECUTE in
;;       older versions, and EXECUTE may not be called when using the
;;       IDL Virtual Machine.
;;
;; NOTE! The (required) programs of mpfit
;;       (cf. http://cow.physics.wisc.edu/~craigm/idl/idl.html) must
;;       be present under the 'markwardt' directory in the p3d root.
;;       It is not necessary to move the files there, a soft link
;;       suffices ('cd <p3d_path>; ln -s <markwardt_path> markwardt').

path=getenv('p3d_path')
cd,path

print,'p3d_tool_makevm: directory="'+path+'"'

;; Resetting the environment in order to inly include the data
;; used for p3d in the SAV file:
.full_reset_session

;; ===============----------
;; First compiling routines of the astro-lib...
;;   The next routines must be compiled first, in this order, to
;;   ensure a proper compilation of the remaining routines:
@contrib/astro-lib/pro/fxbintable.pro
.com contrib/astro-lib/pro/gettok.pro
.com contrib/astro-lib/pro/valid_num.pro
.com contrib/astro-lib/pro/fxpar.pro
.com contrib/astro-lib/pro/sxpar.pro
.com contrib/astro-lib/pro/fxparpos.pro
.com contrib/astro-lib/pro/fxmove.pro
.com contrib/astro-lib/pro/is_ieee_big.pro
.com contrib/astro-lib/pro/strnumber.pro
.com contrib/astro-lib/pro/readfits.pro

;;   Now compiling the remaining required routines in astro-lib:
.com contrib/astro-lib/pro/blkshift.pro
.com contrib/astro-lib/pro/boost_array.pro
.com contrib/astro-lib/pro/check_fits.pro
.com contrib/astro-lib/pro/checksum32.pro
.com contrib/astro-lib/pro/correl_images.pro
.com contrib/astro-lib/pro/corrmat_analyze.pro
.com contrib/astro-lib/pro/daycnv.pro
.com contrib/astro-lib/pro/detabify.pro
.com contrib/astro-lib/pro/fdecomp.pro
.com contrib/astro-lib/pro/fits_ascii_encode.pro
.com contrib/astro-lib/pro/fits_add_checksum.pro
.com contrib/astro-lib/pro/fits_test_checksum.pro
.com contrib/astro-lib/pro/fxaddpar.pro
.com contrib/astro-lib/pro/fxbcreate.pro
.com contrib/astro-lib/pro/fxbfind.pro
.com contrib/astro-lib/pro/fxbfinish.pro
.com contrib/astro-lib/pro/fxbparse.pro
.com contrib/astro-lib/pro/fxbtform.pro
.com contrib/astro-lib/pro/fxbwrite.pro
.com contrib/astro-lib/pro/fxfindend.pro
.com contrib/astro-lib/pro/fxhclean.pro
.com contrib/astro-lib/pro/fxhmake.pro
.com contrib/astro-lib/pro/fxhmodify.pro
.com contrib/astro-lib/pro/fxhread.pro
.com contrib/astro-lib/pro/fxposit.pro
.com contrib/astro-lib/pro/fxread.pro
.com contrib/astro-lib/pro/fxwrite.pro
.com contrib/astro-lib/pro/get_date.pro
.com contrib/astro-lib/pro/headfits.pro
.com contrib/astro-lib/pro/host_to_ieee.pro
.com contrib/astro-lib/pro/ieee_to_host.pro
.com contrib/astro-lib/pro/mkhdr.pro
.com contrib/astro-lib/pro/month_cnv.pro
.com contrib/astro-lib/pro/mrd_hread.pro
.com contrib/astro-lib/pro/mrd_skip.pro
.com contrib/astro-lib/pro/plotsym.pro
.com contrib/astro-lib/pro/readcol.pro
.com contrib/astro-lib/pro/remchar.pro
.com contrib/astro-lib/pro/repchr.pro
.com contrib/astro-lib/pro/store_array.pro
.com contrib/astro-lib/pro/sxaddpar.pro
.com contrib/astro-lib/pro/sxdelpar.pro
.com contrib/astro-lib/pro/writefits.pro
.com contrib/astro-lib/pro/zparcheck.pro

;; ===============----------
;; Secondly compiling routines of mpfit...
.com contrib/mpfit.pro
.com contrib/mpcurvefit.pro

;; ===============----------
;; Now compiling all routines of the p3d package:
.com p3d.pro
.com p3d_rss.pro
.com p3d_imv.pro
.com p3d_cmbias.pro
.com p3d_ctrace.pro
.com p3d_cdmask.pro
.com p3d_cflatf.pro
.com p3d_cobjex.pro
.com routines/p3d_display_grat_plot.pro
.com routines/p3d_display_lineprofiles.pro
.com routines/p3d_display_tele.pro
.com routines/p3d_display_telescl_postable.pro
.com routines/p3d_gui.pro
.com routines/p3d_extract.pro
.com routines/p3d_extract_prepare_extraction.pro
.com routines/p3d_extract_tophat.pro
.com routines/p3d_extract_optimal_mox.pro
.com routines/p3d_extract_optimal_mpd.pro
.com routines/p3d_extract_optimal.pro
.com routines/p3d_flatfield.pro
.com routines/p3d_masterbias_smooth.pro
.com routines/p3d_masterbias_smooth_file.pro
.com routines/p3d_misc_binextract.pro
.com routines/p3d_misc_checkfile
.com routines/p3d_misc_choose.pro
.com routines/p3d_misc_colortable.pro
.com routines/p3d_misc_correlate_arrays.pro
.com routines/p3d_misc_dataclip.pro
.com routines/p3d_misc_detsec.pro
.com routines/p3d_misc_e3dio_write.pro
.com routines/p3d_misc_errors.pro
.com routines/p3d_misc_extract_method.pro
.com routines/p3d_misc_fileallbl.pro
.com routines/p3d_misc_findspec.pro
.com routines/p3d_misc_fitsparsplit.pro
.com routines/p3d_misc_fitsstrex.pro
.com routines/p3d_misc_getinformation.pro
.com routines/p3d_misc_get_hdr_kwrd.pro
.com routines/p3d_misc_imcombine.pro
.com routines/p3d_misc_imcombine_wrapper.pro
.com routines/p3d_misc_initialize.pro
.com routines/p3d_misc_logger.pro
.com routines/p3d_misc_mean_smooth.pro
.com routines/p3d_misc_mean_smooth_small.pro
.com routines/p3d_misc_median_smooth.pro
.com routines/p3d_misc_mmodhdr.pro
.com routines/p3d_misc_pathify.pro
.com routines/p3d_misc_profunction.pro
.com routines/p3d_misc_read_params.pro
.com routines/p3d_misc_read_postable.pro
.com routines/p3d_misc_retrieve_lprofs.pro
.com routines/p3d_misc_sauron_colormap.pro
.com routines/p3d_misc_smooth_1d.pro
.com routines/p3d_tracing_correctpos.pro
.com routines/p3d_tracing_expand_traces.pro
.com routines/p3d_tracing_findspec.pro
.com routines/p3d_tracing_findspec0.pro
.com routines/p3d_tracing_trace.pro
.com routines/p3d_tracing_calculate_lprofs.pro
.com routines/p3d_tracing_calculate_lprofs_fits.pro
.com routines/p3d_wavecal_calculate_mcurv.pro
.com routines/p3d_wavecal_correct_maskpos.pro
.com routines/p3d_wavecal_delete_spec.pro
.com routines/p3d_wavecal_dispersion_correction.pro
.com routines/p3d_wavecal_dispmask_add_spec.pro
.com routines/p3d_wavecal_dispmask_gui.pro
.com routines/p3d_wavecal_fit_maskwd.pro
.com routines/p3d_wavecal_grating_eq.pro
.com routines/p3d_wavecal_match_maskwd.pro
.com routines/p3d_wavecal_set_linelist.pro
.com routines/p3d_wavecal_unfold_dispmask_file.pro
resolve_all,skip_routines=['trnlog','dellog','setlog']
save,/routines,filename='vm/p3d.sav'
